/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import io.sirix.cache.Cache;
import io.sirix.cache.RBIndexKey;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.node.interfaces.Node;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RedBlackTreeNodeCache
implements Cache<RBIndexKey, Node> {
    private final com.github.benmanes.caffeine.cache.Cache<RBIndexKey, Node> cache;

    public RedBlackTreeNodeCache(int maxSize) {
        RemovalListener removalListener = (key, value, cause) -> {
            RBNodeKey rbNodeKey;
            RBNodeKey parent;
            assert (key != null);
            assert (value != null);
            if (value instanceof RBNodeKey && (parent = (rbNodeKey = (RBNodeKey)value).getParent()) != null) {
                if (value.equals(parent.getLeftChild())) {
                    parent.setLeftChild(null);
                } else if (value.equals(parent.getRightChild())) {
                    parent.setRightChild(null);
                }
            }
        };
        this.cache = Caffeine.newBuilder().maximumSize((long)maxSize).removalListener(removalListener).scheduler(scheduler).build();
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public Node get(RBIndexKey key) {
        return (Node)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void put(RBIndexKey key, @NonNull Node value) {
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends RBIndexKey, ? extends Node> map) {
        this.cache.putAll(map);
    }

    @Override
    public void toSecondCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<RBIndexKey, Node> getAll(Iterable<? extends RBIndexKey> keys) {
        return this.cache.getAllPresent(keys);
    }

    @Override
    public void remove(RBIndexKey key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void close() {
    }
}

