/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.sirix.cache.Cache;
import io.sirix.page.RevisionRootPage;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class RevisionRootPageCache
implements Cache<Integer, RevisionRootPage> {
    private final com.github.benmanes.caffeine.cache.Cache<Integer, RevisionRootPage> pageCache;

    public RevisionRootPageCache(int maxSize) {
        this.pageCache = Caffeine.newBuilder().maximumSize((long)maxSize).expireAfterAccess(5L, TimeUnit.MINUTES).scheduler(scheduler).build();
    }

    @Override
    public void clear() {
        this.pageCache.invalidateAll();
    }

    @Override
    public RevisionRootPage get(Integer key) {
        RevisionRootPage revisionRootPage = (RevisionRootPage)this.pageCache.getIfPresent((Object)key);
        if (revisionRootPage != null) {
            revisionRootPage = new RevisionRootPage(revisionRootPage, revisionRootPage.getRevision());
        }
        return revisionRootPage;
    }

    @Override
    public void put(Integer key, RevisionRootPage value) {
        this.pageCache.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends RevisionRootPage> map) {
        this.pageCache.putAll(map);
    }

    @Override
    public void toSecondCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Integer, RevisionRootPage> getAll(Iterable<? extends Integer> keys) {
        return this.pageCache.getAllPresent(keys);
    }

    @Override
    public void remove(Integer key) {
        this.pageCache.invalidate((Object)key);
    }

    @Override
    public void close() {
    }
}

