/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public final class DiffTuple
implements Serializable {
    private static final long serialVersionUID = -8805161170968505227L;
    private DiffFactory.DiffType diff;
    private final long newNodeKey;
    private final long oldNodeKey;
    private final DiffDepth depth;
    private int index;

    public DiffTuple(DiffFactory.DiffType diff, long newNodeKey, long oldNodeKey, DiffDepth depth) {
        Preconditions.checkArgument((newNodeKey >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((oldNodeKey >= 0L ? 1 : 0) != 0);
        this.diff = Objects.requireNonNull(diff);
        this.newNodeKey = newNodeKey;
        this.oldNodeKey = oldNodeKey;
        this.depth = depth;
    }

    public DiffFactory.DiffType getDiff() {
        return this.diff;
    }

    public DiffTuple setDiff(DiffFactory.DiffType diffType) {
        this.diff = Objects.requireNonNull(diffType);
        return this;
    }

    public DiffTuple setIndex(@NonNegative int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        this.index = index;
        return this;
    }

    public long getNewNodeKey() {
        return this.newNodeKey;
    }

    public long getOldNodeKey() {
        return this.oldNodeKey;
    }

    public DiffDepth getDepth() {
        return this.depth;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("diff", (Object)this.diff).add("new nodeKey", this.newNodeKey).add("old nodeKey", this.oldNodeKey).toString();
    }

    public int getIndex() {
        return this.index;
    }
}

