/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.diff.AbstractDiff;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.node.NodeKind;
import java.util.Objects;

final class JsonDiff
extends AbstractDiff<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    public JsonDiff(DiffFactory.Builder<JsonNodeReadOnlyTrx, JsonNodeTrx> builder) {
        super(builder);
    }

    @Override
    NodeKind documentNode() {
        return NodeKind.JSON_DOCUMENT;
    }

    @Override
    boolean checkNodes(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getNodeKey() == oldRtx.getNodeKey() && newRtx.getParentKey() == oldRtx.getParentKey() && newRtx.getKind() == oldRtx.getKind()) {
            found = this.checkNamesOrValues(newRtx, oldRtx);
        }
        return found;
    }

    private boolean checkNamesOrValues(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        switch (newRtx.getKind()) {
            case ARRAY: 
            case OBJECT: 
            case NULL_VALUE: 
            case OBJECT_NULL_VALUE: {
                found = true;
                break;
            }
            case OBJECT_KEY: {
                if (!this.checkNamesForEquality(newRtx, oldRtx)) break;
                found = true;
                break;
            }
            case BOOLEAN_VALUE: 
            case OBJECT_BOOLEAN_VALUE: {
                if (newRtx.getBooleanValue() != oldRtx.getBooleanValue()) break;
                found = true;
                break;
            }
            case NUMBER_VALUE: 
            case OBJECT_NUMBER_VALUE: {
                if (!Objects.equals(newRtx.getNumberValue(), oldRtx.getNumberValue())) break;
                found = true;
                break;
            }
            case STRING_VALUE: 
            case OBJECT_STRING_VALUE: {
                if (!Objects.equals(newRtx.getValue(), oldRtx.getValue())) break;
                found = true;
                break;
            }
        }
        return found;
    }

    private boolean checkNamesForEquality(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        return newRtx.getNameKey() == oldRtx.getNameKey();
    }

    @Override
    void emitNonStructuralDiff(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx, DiffDepth depth, DiffFactory.DiffType diff) {
    }

    @Override
    boolean checkNodeNamesOrValues(JsonNodeReadOnlyTrx newRtx, JsonNodeReadOnlyTrx oldRtx) {
        return this.checkNamesOrValues(newRtx, oldRtx);
    }
}

