/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff;

import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.diff.AbstractDiff;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.node.NodeKind;

final class XmlStructuralDiff
extends AbstractDiff<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    public XmlStructuralDiff(DiffFactory.Builder<XmlNodeReadOnlyTrx, XmlNodeTrx> builder) {
        super(builder);
    }

    @Override
    NodeKind documentNode() {
        return NodeKind.XML_DOCUMENT;
    }

    @Override
    boolean checkNodes(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getNodeKey() == oldRtx.getNodeKey() && newRtx.getParentKey() == oldRtx.getParentKey() && newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: {
                    if (!this.checkNamesForEquality(newRtx, oldRtx)) break;
                    found = true;
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    found = newRtx.getValue().equals(oldRtx.getValue()) && this.checkNamesForEquality(newRtx, oldRtx);
                    break;
                }
                case COMMENT: 
                case TEXT: {
                    if (!newRtx.getValue().equals(oldRtx.getValue())) break;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    @Override
    boolean checkNodeNamesOrValues(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        boolean found = false;
        if (newRtx.getKind() == oldRtx.getKind()) {
            switch (newRtx.getKind()) {
                case ELEMENT: 
                case PROCESSING_INSTRUCTION: {
                    if (!this.checkNamesForEquality(newRtx, oldRtx)) break;
                    found = true;
                    break;
                }
                case COMMENT: 
                case TEXT: {
                    if (!newRtx.getValue().equals(oldRtx.getValue())) break;
                    found = true;
                    break;
                }
            }
        }
        return found;
    }

    @Override
    void emitNonStructuralDiff(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx, DiffDepth depth, DiffFactory.DiffType diff) {
    }

    protected boolean checkNamesForEquality(XmlNodeReadOnlyTrx newRtx, XmlNodeReadOnlyTrx oldRtx) {
        return newRtx.getURIKey() == oldRtx.getURIKey() && newRtx.getLocalNameKey() == oldRtx.getLocalNameKey() && newRtx.getPrefixKey() == oldRtx.getPrefixKey();
    }
}

