/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.sirix.access.trx.node.xml.AbstractXmlNodeVisitor;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.xml.ImmutableComment;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.immutable.xml.ImmutablePI;
import io.sirix.node.immutable.xml.ImmutableText;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import java.util.Map;
import java.util.Objects;

public final class FMSEVisitor
extends AbstractXmlNodeVisitor {
    private final XmlNodeReadOnlyTrx rtx;
    private final Map<Long, Boolean> inOrder;
    private final Map<Long, Long> descendants;

    public FMSEVisitor(XmlNodeReadOnlyTrx readTransaction, Map<Long, Boolean> inOrder, Map<Long, Long> descendants) {
        this.rtx = Objects.requireNonNull(readTransaction);
        this.inOrder = Objects.requireNonNull(inOrder);
        this.descendants = Objects.requireNonNull(descendants);
    }

    @Override
    public VisitResultType visit(ImmutableElement node) {
        int i;
        long nodeKey = node.getNodeKey();
        this.rtx.moveTo(nodeKey);
        int attCount = this.rtx.getAttributeCount();
        for (i = 0; i < attCount; ++i) {
            this.rtx.moveToAttribute(i);
            this.fillStructuralDataStructures();
            this.rtx.moveTo(nodeKey);
        }
        int nspCount = this.rtx.getNamespaceCount();
        for (i = 0; i < nspCount; ++i) {
            this.rtx.moveToNamespace(i);
            this.fillStructuralDataStructures();
            this.rtx.moveTo(nodeKey);
        }
        this.countDescendants();
        return VisitResultType.CONTINUE;
    }

    private void fillStructuralDataStructures() {
        this.inOrder.put(this.rtx.getNodeKey(), true);
        this.descendants.put(this.rtx.getNodeKey(), 1L);
    }

    private void countDescendants() {
        long descendants = 0L;
        long nodeKey = this.rtx.getNodeKey();
        descendants += (long)this.rtx.getNamespaceCount();
        descendants += (long)this.rtx.getAttributeCount();
        if (this.rtx.hasFirstChild()) {
            this.rtx.moveToFirstChild();
            do {
                descendants += this.descendants.get(this.rtx.getNodeKey()).longValue();
                if (this.rtx.getKind() != NodeKind.ELEMENT) continue;
                ++descendants;
            } while (this.rtx.hasRightSibling() && this.rtx.moveToRightSibling());
        }
        this.rtx.moveTo(nodeKey);
        this.inOrder.put(this.rtx.getNodeKey(), false);
        this.descendants.put(this.rtx.getNodeKey(), descendants);
    }

    @Override
    public VisitResultType visit(ImmutableText node) {
        return this.visiLeafNode(node);
    }

    @Override
    public VisitResultType visit(ImmutableComment node) {
        return this.visiLeafNode(node);
    }

    @Override
    public VisitResultType visit(ImmutablePI node) {
        return this.visiLeafNode(node);
    }

    private VisitResultType visiLeafNode(ImmutableNode node) {
        long nodeKey = node.getNodeKey();
        this.rtx.moveTo(nodeKey);
        this.inOrder.put(this.rtx.getNodeKey(), false);
        this.descendants.put(this.rtx.getNodeKey(), 1L);
        return VisitResultType.CONTINUE;
    }
}

