/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.brackit.query.atomic.QNm;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.diff.algorithm.fmse.FMSENodeComparisonUtils;
import io.sirix.diff.algorithm.fmse.NodeComparator;
import io.sirix.index.path.summary.PathNode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.node.NodeKind;

final class LeafNodeComparator
implements NodeComparator<Long> {
    public static final double FMESF = 0.5;
    private final QNm mId;
    private final XmlNodeReadOnlyTrx oldRtx;
    private final XmlNodeReadOnlyTrx newRtx;
    private final PathSummaryReader oldPathSummary;
    private final PathSummaryReader newPathSummary;
    private final FMSENodeComparisonUtils nodeComparisonUtils;

    public LeafNodeComparator(QNm id, XmlNodeReadOnlyTrx oldRtx, XmlNodeReadOnlyTrx newRtx, PathSummaryReader oldPathSummary, PathSummaryReader newPathSummary, FMSENodeComparisonUtils nodeComparisonUtils) {
        this.mId = id;
        this.oldRtx = oldRtx;
        this.newRtx = newRtx;
        this.oldPathSummary = oldPathSummary;
        this.newPathSummary = newPathSummary;
        this.nodeComparisonUtils = nodeComparisonUtils;
    }

    @Override
    public boolean isEqual(Long firstNode, Long secondNode) {
        assert (firstNode != null);
        assert (secondNode != null);
        this.oldRtx.moveTo(firstNode);
        this.newRtx.moveTo(secondNode);
        assert (this.oldRtx.getKind() == this.newRtx.getKind());
        double ratio = 0.0;
        if (this.oldRtx.getKind() == NodeKind.ATTRIBUTE || this.oldRtx.getKind() == NodeKind.NAMESPACE || this.oldRtx.getKind() == NodeKind.PROCESSING_INSTRUCTION) {
            if (this.oldRtx.getName().equals((Object)this.newRtx.getName())) {
                ratio = 1.0;
                if ((this.oldRtx.getKind() == NodeKind.ATTRIBUTE || this.oldRtx.getKind() == NodeKind.PROCESSING_INSTRUCTION) && (ratio = (double)this.nodeComparisonUtils.calculateRatio(this.oldRtx.getValue(), this.newRtx.getValue())) > 0.5) {
                    Path paths = this.checkPaths();
                    ratio = this.adaptRatioByUsingThePathChecks(paths);
                }
            }
        } else {
            ratio = this.nodeComparisonUtils.nodeValuesEqual(firstNode, secondNode, this.oldRtx, this.newRtx) ? 1.0 : (double)this.nodeComparisonUtils.calculateRatio(this.nodeComparisonUtils.getNodeValue(firstNode, this.oldRtx), this.nodeComparisonUtils.getNodeValue(secondNode, this.newRtx));
            if (ratio > 0.5) {
                this.oldRtx.moveToParent();
                this.newRtx.moveToParent();
                ratio = this.nodeComparisonUtils.calculateRatio(this.nodeComparisonUtils.getNodeValue(this.oldRtx.getNodeKey(), this.oldRtx), this.nodeComparisonUtils.getNodeValue(this.newRtx.getNodeKey(), this.newRtx));
                if (ratio > 0.5) {
                    Path paths = this.checkPaths();
                    ratio = this.adaptRatioByUsingThePathChecks(paths);
                }
            }
        }
        if (ratio > 0.5 && this.mId != null && this.nodeComparisonUtils.checkIfAncestorIdsMatch(this.oldRtx.getNodeKey(), this.newRtx.getNodeKey(), this.mId)) {
            ratio = 1.0;
        }
        this.oldRtx.moveTo(firstNode);
        this.newRtx.moveTo(secondNode);
        return ratio > 0.5;
    }

    private double adaptRatioByUsingThePathChecks(Path paths) {
        double ratio = paths != Path.PATH_LENGTH_IS_NOT_EQUAL && this.mId != null ? (this.nodeComparisonUtils.checkIfAncestorIdsMatch(this.oldRtx.getNodeKey(), this.newRtx.getNodeKey(), this.mId) ? 1.0 : 0.0) : (paths == Path.MATCHES ? 1.0 : (paths == Path.NO_PATH ? (this.nodeComparisonUtils.checkAncestors(this.oldRtx.getNodeKey(), this.newRtx.getNodeKey()) ? 1.0 : 0.0) : 0.0));
        return ratio;
    }

    private Path checkPaths() {
        if (this.oldRtx.getPathNodeKey() == 0L || this.newRtx.getPathNodeKey() == 0L) {
            return Path.NO_PATH;
        }
        PathNode oldPathNode = this.newPathSummary.getPathNodeForPathNodeKey(this.newRtx.getPathNodeKey());
        this.newPathSummary.moveTo(oldPathNode.getNodeKey());
        io.brackit.query.util.path.Path<QNm> oldPath = this.newPathSummary.getPath();
        PathNode newPathNode = this.oldPathSummary.getPathNodeForPathNodeKey(this.oldRtx.getPathNodeKey());
        this.oldPathSummary.moveTo(newPathNode.getNodeKey());
        io.brackit.query.util.path.Path<QNm> newPath = this.oldPathSummary.getPath();
        if (oldPath.getLength() != newPath.getLength()) {
            return Path.PATH_LENGTH_IS_NOT_EQUAL;
        }
        if (oldPath.matches(newPath)) {
            return Path.MATCHES;
        }
        return Path.NO_MATCH_NO_LENGTH_EQUALS;
    }

    private static enum Path {
        NO_PATH,
        MATCHES,
        PATH_LENGTH_IS_NOT_EQUAL,
        NO_MATCH_NO_LENGTH_EQUALS;

    }
}

