/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.diff.algorithm.fmse;

import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.diff.algorithm.fmse.ConnectionMap;
import io.sirix.node.NodeKind;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public final class Matching {
    private final Map<Long, Long> mapping;
    private final Map<Long, Long> reverseMapping;
    private final ConnectionMap<Long> isInSubtree;
    private final XmlNodeReadOnlyTrx rtxOld;
    private final XmlNodeReadOnlyTrx rtxNew;

    public Matching(XmlNodeReadOnlyTrx rtxOld, XmlNodeReadOnlyTrx rtxNew) {
        this.mapping = new HashMap<Long, Long>();
        this.reverseMapping = new HashMap<Long, Long>();
        this.isInSubtree = new ConnectionMap();
        this.rtxOld = Objects.requireNonNull(rtxOld);
        this.rtxNew = Objects.requireNonNull(rtxNew);
    }

    public Matching(Matching match) {
        this.mapping = new HashMap<Long, Long>(match.mapping);
        this.reverseMapping = new HashMap<Long, Long>(match.reverseMapping);
        this.isInSubtree = new ConnectionMap<Long>(match.isInSubtree);
        this.rtxOld = match.rtxOld;
        this.rtxNew = match.rtxNew;
    }

    public void add(@NonNegative long nodeX, @NonNegative long nodeY) {
        this.rtxOld.moveTo(nodeX);
        this.rtxNew.moveTo(nodeY);
        if (this.rtxOld.getKind() != this.rtxNew.getKind()) {
            throw new AssertionError();
        }
        this.mapping.put(nodeX, nodeY);
        this.reverseMapping.put(nodeY, nodeX);
        this.updateSubtreeMap(nodeX, this.rtxOld);
        this.updateSubtreeMap(nodeY, this.rtxNew);
    }

    public boolean remove(@NonNegative long nodeX) {
        this.reverseMapping.remove(this.mapping.get(nodeX));
        return this.mapping.remove(nodeX) != null;
    }

    private void updateSubtreeMap(@NonNegative long key, XmlNodeReadOnlyTrx rtx) {
        assert (key >= 0L);
        assert (rtx != null);
        this.isInSubtree.set(key, key, true);
        rtx.moveTo(key);
        if (rtx.hasParent()) {
            while (rtx.hasParent()) {
                rtx.moveToParent();
                this.isInSubtree.set(rtx.getNodeKey(), key, true);
            }
            rtx.moveTo(key);
        }
    }

    public boolean contains(@NonNegative long nodeX, @NonNegative long nodeY) {
        return this.mapping.get(nodeX) != null && this.mapping.get(nodeX).equals(nodeY);
    }

    public long containedDescendants(@NonNegative long nodeX, @NonNegative long nodeY) {
        long retVal = 0L;
        this.rtxOld.moveTo(nodeX);
        DescendantAxis axis = new DescendantAxis(this.rtxOld, IncludeSelf.YES);
        while (axis.hasNext()) {
            int i;
            axis.nextLong();
            retVal += this.isInSubtree.get(nodeY, this.partner(this.rtxOld.getNodeKey())) ? 1L : 0L;
            if (this.rtxOld.getKind() != NodeKind.ELEMENT) continue;
            int nspCount = this.rtxOld.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                this.rtxOld.moveToNamespace(i);
                retVal += this.isInSubtree.get(nodeY, this.partner(axis.asXmlNodeReadTrx().getNodeKey())) ? 1L : 0L;
                this.rtxOld.moveToParent();
            }
            int attCount = this.rtxOld.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                this.rtxOld.moveToAttribute(i);
                retVal += this.isInSubtree.get(nodeY, this.partner(axis.asXmlNodeReadTrx().getNodeKey())) ? 1L : 0L;
                this.rtxOld.moveToParent();
            }
        }
        return retVal;
    }

    public Long partner(@NonNegative long node) {
        return this.mapping.get(node);
    }

    public Long reversePartner(@NonNegative long node) {
        return this.reverseMapping.get(node);
    }

    public void reset() {
        this.mapping.clear();
        this.reverseMapping.clear();
        this.isInSubtree.reset();
    }
}

