/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Dec;
import io.brackit.query.atomic.Flt;
import io.brackit.query.atomic.Int;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.Str;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Type;
import io.sirix.exception.SirixException;
import io.sirix.exception.SirixRuntimeException;
import io.sirix.utils.Calc;

public final class AtomicUtil {
    public static byte[] toBytes(Atomic atomic, Type type) throws SirixException {
        if (atomic == null) {
            return null;
        }
        return AtomicUtil.toBytes(AtomicUtil.toType(atomic, type));
    }

    public static byte[] toBytes(Atomic atomic) {
        if (atomic == null) {
            return null;
        }
        Type type = atomic.type();
        if (!type.isBuiltin()) {
            throw new SirixRuntimeException("%s is not a built-in type", type);
        }
        if (type.instanceOf(Type.STR)) {
            return Calc.fromString(atomic.stringValue());
        }
        if (type.instanceOf(Type.BOOL)) {
            byte[] byArray;
            if (atomic.booleanValue()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            return byArray;
        }
        if (type.isNumeric()) {
            if (type.instanceOf(Type.DBL)) {
                return Calc.fromDouble(((Numeric)atomic).doubleValue());
            }
            if (type.instanceOf(Type.FLO)) {
                return Calc.fromFloat(((Numeric)atomic).floatValue());
            }
            if (type.instanceOf(Type.INT)) {
                return Calc.fromInt(((Numeric)atomic).intValue());
            }
            if (type.instanceOf(Type.LON)) {
                return Calc.fromLong(((Numeric)atomic).longValue());
            }
            if (type.instanceOf(Type.INR)) {
                return Calc.fromBigDecimal(((Numeric)atomic).decimalValue());
            }
            if (type.instanceOf(Type.DEC)) {
                return Calc.fromBigDecimal(((Numeric)atomic).decimalValue());
            }
        }
        throw new SirixRuntimeException("Unsupported type: %s", type);
    }

    public static Atomic fromBytes(byte[] b, Type type) {
        if (!type.isBuiltin()) {
            throw new SirixRuntimeException("%s is not a built-in type", type);
        }
        if (type.instanceOf(Type.STR)) {
            return new Str(Calc.toString(b));
        }
        if (type.instanceOf(Type.BOOL)) {
            return new Bool(b[0] == 1);
        }
        if (type.isNumeric()) {
            if (type.instanceOf(Type.DBL)) {
                return new Dbl(Calc.toDouble(b));
            }
            if (type.instanceOf(Type.FLO)) {
                return new Flt(Calc.toFloat(b));
            }
            if (type.instanceOf(Type.INT)) {
                return new Int32(Calc.toInt(b));
            }
            if (type.instanceOf(Type.LON)) {
                return new Int64(Calc.toLong(b));
            }
            if (type.instanceOf(Type.INR)) {
                return new Int(Calc.toBigDecimal(b));
            }
            if (type.instanceOf(Type.DEC)) {
                return new Dec(Calc.toBigDecimal(b));
            }
        }
        throw new SirixRuntimeException("Unsupported type: %s", type);
    }

    public static Atomic toType(Atomic atomic, Type type) {
        try {
            return Cast.cast(null, (Atomic)atomic, (Type)type);
        }
        catch (QueryException e) {
            throw new SirixRuntimeException(e);
        }
    }
}

