/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AdaptiveRadixTree;
import io.sirix.index.art.AscendingSubMap;
import io.sirix.index.art.LeafNode;
import io.sirix.index.art.NavigableSubMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class DescendingSubMap<K, V>
extends NavigableSubMap<K, V> {
    DescendingSubMap(AdaptiveRadixTree<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
        super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.tree.comparator();
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (!this.inRange(fromKey, fromInclusive)) {
            throw new IllegalArgumentException("fromKey out of range");
        }
        if (!this.inRange(toKey, toInclusive)) {
            throw new IllegalArgumentException("toKey out of range");
        }
        return new DescendingSubMap<K, V>(this.tree, false, toKey, toInclusive, false, fromKey, fromInclusive);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        if (!this.inRange(toKey, inclusive)) {
            throw new IllegalArgumentException("toKey out of range");
        }
        return new DescendingSubMap<Object, V>(this.tree, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        if (!this.inRange(fromKey, inclusive)) {
            throw new IllegalArgumentException("fromKey out of range");
        }
        return new DescendingSubMap<Object, V>(this.tree, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        AscendingSubMap mapView = this.descendingMapView;
        return mapView != null ? mapView : (this.descendingMapView = new AscendingSubMap(this.tree, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
    }

    @Override
    Iterator<K> keyIterator() {
        return new NavigableSubMap.DescendingSubMapKeyIterator(this, this.absHighest(), this.absLowFence());
    }

    @Override
    Spliterator<K> keySpliterator() {
        return new NavigableSubMap.DescendingSubMapKeyIterator(this, this.absHighest(), this.absLowFence());
    }

    @Override
    Iterator<K> descendingKeyIterator() {
        return new NavigableSubMap.SubMapKeyIterator(this, this.absLowest(), this.absHighFence());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        NavigableSubMap.EntrySetView es = this.entrySetView;
        return es != null ? es : (this.entrySetView = new DescendingEntrySetView());
    }

    @Override
    LeafNode<K, V> subLowest() {
        return this.absHighest();
    }

    @Override
    LeafNode<K, V> subHighest() {
        return this.absLowest();
    }

    @Override
    LeafNode<K, V> subCeiling(K key) {
        return this.absFloor(key);
    }

    @Override
    LeafNode<K, V> subHigher(K key) {
        return this.absLower(key);
    }

    @Override
    LeafNode<K, V> subFloor(K key) {
        return this.absCeiling(key);
    }

    @Override
    LeafNode<K, V> subLower(K key) {
        return this.absHigher(key);
    }

    final class DescendingEntrySetView
    extends NavigableSubMap.EntrySetView {
        DescendingEntrySetView() {
            super(DescendingSubMap.this);
        }

        @Override
        public @NonNull Iterator<Map.Entry<K, V>> iterator() {
            return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this, DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
        }
    }
}

