/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AdaptiveRadixTree;
import io.sirix.index.art.LeafNode;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

class EntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final AdaptiveRadixTree<K, V> tree;

    EntrySet(AdaptiveRadixTree<K, V> tree) {
        this.tree = tree;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.tree.entryIterator();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        Object value = entry.getValue();
        LeafNode<K, V> p = this.tree.getEntry(entry.getKey());
        return p != null && AdaptiveRadixTree.valEquals(p.getValue(), value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        Object value = entry.getValue();
        LeafNode<K, V> p = this.tree.getEntry(entry.getKey());
        if (p != null && AdaptiveRadixTree.valEquals(p.getValue(), value)) {
            this.tree.deleteEntry(p);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }
}

