/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AdaptiveRadixTree;
import io.sirix.index.art.NavigableSubMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.NonNull;

final class KeySet<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    private final NavigableMap<E, ?> map;

    KeySet(NavigableMap<E, ?> map) {
        this.map = map;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.map instanceof AdaptiveRadixTree) {
            return ((AdaptiveRadixTree)this.map).keyIterator();
        }
        return ((NavigableSubMap)this.map).keyIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        if (this.map instanceof AdaptiveRadixTree) {
            return ((AdaptiveRadixTree)this.map).descendingKeyIterator();
        }
        return ((NavigableSubMap)this.map).descendingKeyIterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public E lower(E e) {
        return this.map.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        return this.map.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        return this.map.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        return this.map.higherKey(e);
    }

    @Override
    public E first() {
        return (E)this.map.firstKey();
    }

    @Override
    public E last() {
        return (E)this.map.lastKey();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.map.comparator();
    }

    @Override
    public E pollFirst() {
        Map.Entry<E, ?> e = this.map.pollFirstEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry<E, ?> e = this.map.pollLastEntry();
        return e == null ? null : (E)e.getKey();
    }

    @Override
    public boolean remove(Object o) {
        int oldSize = this.size();
        this.map.remove(o);
        return this.size() != oldSize;
    }

    @Override
    public @NonNull NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new KeySet<E>(this.map.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public @NonNull NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new KeySet<E>(this.map.headMap(toElement, inclusive));
    }

    @Override
    public @NonNull NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new KeySet<E>(this.map.tailMap(fromElement, inclusive));
    }

    @Override
    public @NonNull SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public @NonNull SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public @NonNull SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public @NonNull NavigableSet<E> descendingSet() {
        return new KeySet<E>(this.map.descendingMap());
    }
}

