/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.Node;
import java.util.Arrays;
import java.util.Map;

class LeafNode<K, V>
extends Node
implements Map.Entry<K, V> {
    private V value;
    private final byte[] keyBytes;
    private final K key;

    LeafNode(byte[] keyBytes, K key, V value) {
        this.value = value;
        this.keyBytes = Arrays.copyOf(keyBytes, keyBytes.length);
        this.key = key;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    byte[] getKeyBytes() {
        return this.keyBytes;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public Node first() {
        return null;
    }

    @Override
    public Node firstOrLeaf() {
        return null;
    }

    @Override
    public Node last() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return String.valueOf(this.key) + "=" + String.valueOf(this.value);
    }
}

