/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.AdaptiveRadixTree;
import io.sirix.index.art.KeySet;
import io.sirix.index.art.LeafNode;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.Consumer;

abstract class NavigableSubMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    final AdaptiveRadixTree<K, V> tree;
    final K lo;
    final K hi;
    final byte[] loBytes;
    final byte[] hiBytes;
    final boolean fromStart;
    final boolean toEnd;
    final boolean loInclusive;
    final boolean hiInclusive;
    transient NavigableMap<K, V> descendingMapView;
    transient EntrySetView entrySetView;
    transient KeySet<K> navigableKeySetView;
    private static final Object UNBOUNDED = new Object();

    NavigableSubMap(AdaptiveRadixTree<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
        this.loBytes = fromStart ? null : m.binaryComparable().get(lo);
        byte[] byArray = this.hiBytes = toEnd ? null : m.binaryComparable().get(hi);
        if (!fromStart && !toEnd) {
            if (AdaptiveRadixTree.compare(this.loBytes, 0, this.loBytes.length, this.hiBytes, 0, this.hiBytes.length) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
        }
        this.tree = m;
        this.fromStart = fromStart;
        this.lo = lo;
        this.loInclusive = loInclusive;
        this.toEnd = toEnd;
        this.hi = hi;
        this.hiInclusive = hiInclusive;
    }

    final boolean tooLow(K key) {
        int c;
        return !this.fromStart && ((c = this.tree.compare(key, this.loBytes)) < 0 || c == 0 && !this.loInclusive);
    }

    final boolean tooHigh(K key) {
        int c;
        return !this.toEnd && ((c = this.tree.compare(key, this.hiBytes)) > 0 || c == 0 && !this.hiInclusive);
    }

    final boolean inRange(K key) {
        return !this.tooLow(key) && !this.tooHigh(key);
    }

    final boolean inClosedRange(K key) {
        return !(!this.fromStart && this.tree.compare(key, this.loBytes) < 0 || !this.toEnd && this.tree.compare(key, this.hiBytes) > 0);
    }

    final boolean inRange(K key, boolean inclusive) {
        return inclusive ? this.inRange(key) : this.inClosedRange(key);
    }

    final LeafNode<K, V> absLowest() {
        LeafNode<K, V> e = this.fromStart ? this.tree.getFirstEntry() : (this.loInclusive ? this.tree.getCeilingEntry(this.loBytes) : this.tree.getHigherEntry(this.loBytes));
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absHighest() {
        LeafNode<K, V> e = this.toEnd ? this.tree.getLastEntry() : (this.hiInclusive ? this.tree.getFloorEntry(this.hiBytes) : this.tree.getLowerEntry(this.hiBytes));
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absCeiling(K key) {
        if (this.tooLow(key)) {
            return this.absLowest();
        }
        LeafNode<K, V> e = this.tree.getCeilingEntry(key);
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absHigher(K key) {
        if (this.tooLow(key)) {
            return this.absLowest();
        }
        LeafNode<K, V> e = this.tree.getHigherEntry(key);
        return e == null || this.tooHigh(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absFloor(K key) {
        if (this.tooHigh(key)) {
            return this.absHighest();
        }
        LeafNode<K, V> e = this.tree.getFloorEntry(key);
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absLower(K key) {
        if (this.tooHigh(key)) {
            return this.absHighest();
        }
        LeafNode<K, V> e = this.tree.getLowerEntry(key);
        return e == null || this.tooLow(e.getKey()) ? null : e;
    }

    final LeafNode<K, V> absHighFence() {
        return this.toEnd ? null : (this.hiInclusive ? this.tree.getHigherEntry(this.hiBytes) : this.tree.getCeilingEntry(this.hiBytes));
    }

    final LeafNode<K, V> absLowFence() {
        return this.fromStart ? null : (this.loInclusive ? this.tree.getLowerEntry(this.loBytes) : this.tree.getFloorEntry(this.loBytes));
    }

    abstract LeafNode<K, V> subLowest();

    abstract LeafNode<K, V> subHighest();

    abstract LeafNode<K, V> subCeiling(K var1);

    abstract LeafNode<K, V> subHigher(K var1);

    abstract LeafNode<K, V> subFloor(K var1);

    abstract LeafNode<K, V> subLower(K var1);

    abstract Iterator<K> keyIterator();

    abstract Spliterator<K> keySpliterator();

    abstract Iterator<K> descendingKeyIterator();

    @Override
    public boolean isEmpty() {
        return this.fromStart && this.toEnd ? this.tree.isEmpty() : this.entrySet().isEmpty();
    }

    @Override
    public int size() {
        return this.fromStart && this.toEnd ? this.tree.size() : this.entrySet().size();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.inRange(key) && this.tree.containsKey(key);
    }

    @Override
    public final V put(K key, V value) {
        if (!this.inRange(key)) {
            throw new IllegalArgumentException("key out of range");
        }
        return this.tree.put(key, value);
    }

    @Override
    public final V get(Object key) {
        return !this.inRange(key) ? null : (V)this.tree.get(key);
    }

    @Override
    public final V remove(Object key) {
        return !this.inRange(key) ? null : (V)this.tree.remove(key);
    }

    @Override
    public final Map.Entry<K, V> ceilingEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.subCeiling(key));
    }

    @Override
    public final K ceilingKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.subCeiling(key));
    }

    @Override
    public final Map.Entry<K, V> higherEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.subHigher(key));
    }

    @Override
    public final K higherKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.subHigher(key));
    }

    @Override
    public final Map.Entry<K, V> floorEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.subFloor(key));
    }

    @Override
    public final K floorKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.subFloor(key));
    }

    @Override
    public final Map.Entry<K, V> lowerEntry(K key) {
        return AdaptiveRadixTree.exportEntry(this.subLower(key));
    }

    @Override
    public final K lowerKey(K key) {
        return AdaptiveRadixTree.keyOrNull(this.subLower(key));
    }

    @Override
    public final K firstKey() {
        return AdaptiveRadixTree.key(this.subLowest());
    }

    @Override
    public final K lastKey() {
        return AdaptiveRadixTree.key(this.subHighest());
    }

    @Override
    public final Map.Entry<K, V> firstEntry() {
        return AdaptiveRadixTree.exportEntry(this.subLowest());
    }

    @Override
    public final Map.Entry<K, V> lastEntry() {
        return AdaptiveRadixTree.exportEntry(this.subHighest());
    }

    @Override
    public final Map.Entry<K, V> pollFirstEntry() {
        LeafNode<K, V> e = this.subLowest();
        Map.Entry<K, V> result = AdaptiveRadixTree.exportEntry(e);
        if (e != null) {
            this.tree.deleteEntry(e);
        }
        return result;
    }

    @Override
    public final Map.Entry<K, V> pollLastEntry() {
        LeafNode<K, V> e = this.subHighest();
        Map.Entry<K, V> result = AdaptiveRadixTree.exportEntry(e);
        if (e != null) {
            this.tree.deleteEntry(e);
        }
        return result;
    }

    @Override
    public final NavigableSet<K> navigableKeySet() {
        KeySet<K> nksv = this.navigableKeySetView;
        return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
    }

    @Override
    public final Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public final SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public final SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public final SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    final class DescendingSubMapKeyIterator
    extends SubMapIterator<K>
    implements Spliterator<K> {
        DescendingSubMapKeyIterator(NavigableSubMap this$0, LeafNode<K, V> last, LeafNode<K, V> fence) {
            super(last, fence);
        }

        @Override
        public K next() {
            return this.prevEntry().getKey();
        }

        @Override
        public Spliterator<K> trySplit() {
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.hasNext()) {
                action.accept(this.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 17;
        }
    }

    final class SubMapKeyIterator
    extends SubMapIterator<K>
    implements Spliterator<K> {
        SubMapKeyIterator(LeafNode<K, V> first, LeafNode<K, V> fence) {
            super(first, fence);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        @Override
        public Spliterator<K> trySplit() {
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.hasNext()) {
                action.accept(this.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 21;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            return NavigableSubMap.this.comparator();
        }
    }

    final class DescendingSubMapEntryIterator
    extends SubMapIterator<Map.Entry<K, V>> {
        DescendingSubMapEntryIterator(NavigableSubMap this$0, LeafNode<K, V> last, LeafNode<K, V> fence) {
            super(last, fence);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.prevEntry();
        }
    }

    final class SubMapEntryIterator
    extends SubMapIterator<Map.Entry<K, V>> {
        SubMapEntryIterator(NavigableSubMap this$0, LeafNode<K, V> first, LeafNode<K, V> fence) {
            super(first, fence);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    abstract class SubMapIterator<T>
    implements Iterator<T> {
        LeafNode<K, V> lastReturned;
        LeafNode<K, V> next;
        final Object fenceKey;
        int expectedModCount;

        SubMapIterator(LeafNode<K, V> first, LeafNode<K, V> fence) {
            this.expectedModCount = NavigableSubMap.this.tree.getModCount();
            this.lastReturned = null;
            this.next = first;
            this.fenceKey = fence == null ? UNBOUNDED : fence.getKey();
        }

        @Override
        public final boolean hasNext() {
            return this.next != null && this.next.getKey() != this.fenceKey;
        }

        final LeafNode<K, V> nextEntry() {
            LeafNode e = this.next;
            if (e == null || e.getKey() == this.fenceKey) {
                throw new NoSuchElementException();
            }
            if (NavigableSubMap.this.tree.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = AdaptiveRadixTree.successor(e);
            this.lastReturned = e;
            return e;
        }

        final LeafNode<K, V> prevEntry() {
            LeafNode e = this.next;
            if (e == null || e.getKey() == this.fenceKey) {
                throw new NoSuchElementException();
            }
            if (NavigableSubMap.this.tree.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = AdaptiveRadixTree.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (NavigableSubMap.this.tree.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            NavigableSubMap.this.tree.deleteEntry(this.lastReturned);
            this.lastReturned = null;
            this.expectedModCount = NavigableSubMap.this.tree.getModCount();
        }
    }

    abstract class EntrySetView
    extends AbstractSet<Map.Entry<K, V>> {
        private transient int size = -1;
        private transient int sizeModCount;

        EntrySetView() {
        }

        @Override
        public int size() {
            if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                return NavigableSubMap.this.tree.size();
            }
            if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.tree.getModCount()) {
                this.sizeModCount = NavigableSubMap.this.tree.getModCount();
                this.size = 0;
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    ++this.size;
                    i.next();
                }
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            LeafNode n = NavigableSubMap.this.absLowest();
            return n == null || NavigableSubMap.this.tooHigh(n.getKey());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (!NavigableSubMap.this.inRange(key)) {
                return false;
            }
            LeafNode node = NavigableSubMap.this.tree.getEntry(key);
            return node != null && AdaptiveRadixTree.valEquals(node.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (!NavigableSubMap.this.inRange(key)) {
                return false;
            }
            LeafNode node = NavigableSubMap.this.tree.getEntry(key);
            if (node != null && AdaptiveRadixTree.valEquals(node.getValue(), entry.getValue())) {
                NavigableSubMap.this.tree.deleteEntry(node);
                return true;
            }
            return false;
        }
    }
}

