/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.art;

import io.sirix.index.art.InnerNode;
import io.sirix.index.art.Node;
import io.sirix.index.art.Node48;

class Node256
extends InnerNode {
    static final int NODE_SIZE = 256;

    Node256(Node48 node) {
        super(node, 256);
        assert (node.isFull());
        byte[] keyIndex = node.getKeyIndex();
        Node[] child = node.getChildren();
        for (int i = 0; i < 256; ++i) {
            byte index = keyIndex[i];
            if (index == -1) continue;
            assert (index >= 0 && index <= 47);
            this.children[i] = child[index];
            Node256.replaceUplink(this, this.children[i]);
        }
    }

    @Override
    public Node findChild(byte partialKey) {
        int index = Byte.toUnsignedInt(partialKey);
        return this.children[index];
    }

    @Override
    public void addChild(byte partialKey, Node child) {
        assert (!this.isFull());
        int index = Byte.toUnsignedInt(partialKey);
        assert (this.children[index] == null);
        Node256.createUplink(this, child, partialKey);
        this.children[index] = child;
        this.noOfChildren = (short)(this.noOfChildren + 1);
    }

    @Override
    public void replace(byte partialKey, Node newChild) {
        int index = Byte.toUnsignedInt(partialKey);
        assert (this.children[index] != null);
        this.children[index] = newChild;
        Node256.createUplink(this, newChild, partialKey);
    }

    @Override
    public void removeChild(byte partialKey) {
        int index = Byte.toUnsignedInt(partialKey);
        assert (this.children[index] != null);
        Node256.removeUplink(this.children[index]);
        this.children[index] = null;
        this.noOfChildren = (short)(this.noOfChildren - 1);
    }

    @Override
    public InnerNode grow() {
        throw new UnsupportedOperationException("Span of ART is 8 bits, so Node256 is the largest node type.");
    }

    @Override
    public boolean shouldShrink() {
        return this.noOfChildren == 48;
    }

    @Override
    public InnerNode shrink() {
        assert (this.shouldShrink());
        return new Node48(this);
    }

    @Override
    public Node first() {
        assert (this.noOfChildren > 48);
        int i = 0;
        while (this.children[i] == null) {
            ++i;
        }
        return this.children[i];
    }

    @Override
    public Node last() {
        assert (this.noOfChildren > 48);
        int i = 255;
        while (this.children[i] == null) {
            --i;
        }
        return this.children[i];
    }

    @Override
    public Node ceil(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey); i < 256; ++i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node greater(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey) + 1; i < 256; ++i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node lesser(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey) - 1; i >= 0; --i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public Node floor(byte partialKey) {
        for (int i = Byte.toUnsignedInt(partialKey); i >= 0; --i) {
            if (this.children[i] == null) continue;
            return this.children[i];
        }
        return null;
    }

    @Override
    public boolean isFull() {
        return this.noOfChildren == 256;
    }
}

