/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.sirix.index.Filter;
import io.sirix.index.SearchMode;
import io.sirix.index.path.PCRCollector;
import io.sirix.index.path.PathFilter;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import java.util.Objects;
import java.util.Set;

public final class CASFilter
implements Filter {
    private final PathFilter pathFilter;
    private final Atomic key;
    private final SearchMode mode;

    public CASFilter(Set<Path<QNm>> paths, Atomic key, SearchMode mode, PCRCollector pcrCollector) {
        this.pathFilter = new PathFilter(Objects.requireNonNull(paths), pcrCollector);
        this.key = key;
        this.mode = Objects.requireNonNull(mode);
    }

    public Set<Long> getPCRs() {
        return this.pathFilter.getPCRs();
    }

    public PCRCollector getPCRCollector() {
        return this.pathFilter.getPCRCollector();
    }

    public SearchMode getMode() {
        return this.mode;
    }

    public Atomic getKey() {
        return this.key;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(RBNodeKey<K> node) {
        K key = node.getKey();
        if (key instanceof CASValue) {
            CASValue casValue = (CASValue)key;
            return this.pathFilter.filter(node) && (this.key == null || this.mode.compare(this.key, casValue.getAtomicValue()) == 0);
        }
        return true;
    }
}

