/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.sirix.index.AtomicUtil;
import io.sirix.index.Filter;
import io.sirix.index.path.PCRCollector;
import io.sirix.index.path.PathFilter;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import java.util.Objects;
import java.util.Set;

public final class CASFilterRange
implements Filter {
    private final PathFilter pathFilter;
    private final Atomic min;
    private final Atomic max;
    private final boolean incMin;
    private final boolean incMax;

    public CASFilterRange(Set<Path<QNm>> paths, Atomic min, Atomic max, boolean incMin, boolean incMax, PCRCollector pcrCollector) {
        this.pathFilter = new PathFilter(Objects.requireNonNull(paths), pcrCollector);
        this.min = Objects.requireNonNull(min);
        this.max = Objects.requireNonNull(max);
        this.incMin = incMin;
        this.incMax = incMax;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(RBNodeKey<K> node) {
        K key = node.getKey();
        if (key instanceof CASValue) {
            CASValue casValue = (CASValue)key;
            boolean filtered = this.pathFilter.filter(node);
            if (filtered) {
                return this.inRange(AtomicUtil.toType(casValue.getAtomicValue(), casValue.getType()));
            }
        }
        return false;
    }

    private boolean inRange(Atomic key) {
        int minKeyCompare = this.min != null ? this.min.compareTo((Object)key) : -1;
        int maxKeyCompare = this.max != null ? this.max.compareTo((Object)key) : 1;
        boolean lowerBoundValid = minKeyCompare == 0 && this.incMin || minKeyCompare < 0;
        boolean upperBoundValid = maxKeyCompare == 0 && this.incMax || maxKeyCompare > 0;
        return upperBoundValid && lowerBoundValid;
    }
}

