/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas;

import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixRuntimeException;
import io.sirix.index.AtomicUtil;
import io.sirix.index.SearchMode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.immutable.json.ImmutableBooleanNode;
import io.sirix.node.immutable.json.ImmutableNumberNode;
import io.sirix.node.immutable.json.ImmutableObjectBooleanNode;
import io.sirix.node.immutable.json.ImmutableObjectNumberNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.interfaces.immutable.ImmutableValueNode;
import io.sirix.utils.LogWrapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class CASIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(CASIndexBuilder.class));
    private final RBTreeWriter<CASValue, NodeReferences> indexWriter;
    private final PathSummaryReader pathSummaryReader;
    private final Set<Path<QNm>> paths;
    private final Type type;

    public CASIndexBuilder(RBTreeWriter<CASValue, NodeReferences> indexWriter, PathSummaryReader pathSummaryReader, Set<Path<QNm>> paths, Type type) {
        this.pathSummaryReader = pathSummaryReader;
        this.paths = paths;
        this.indexWriter = indexWriter;
        this.type = type;
    }

    public VisitResult process(ImmutableNode node, long pathNodeKey) {
        block15: {
            try {
                if (!this.paths.isEmpty() && !this.pathSummaryReader.getPCRsForPaths(this.paths).contains(pathNodeKey)) break block15;
                ImmutableNode immutableNode = node;
                int n = 0;
                Str strValue = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImmutableValueNode.class, ImmutableObjectNumberNode.class, ImmutableNumberNode.class, ImmutableObjectBooleanNode.class, ImmutableBooleanNode.class}, (Object)immutableNode, n)) {
                    case 0 -> {
                        ImmutableValueNode immutableValueNode = (ImmutableValueNode)((Object)immutableNode);
                        yield new Str(immutableValueNode.getValue());
                    }
                    case 1 -> {
                        ImmutableObjectNumberNode immutableObjectNumberNode = (ImmutableObjectNumberNode)immutableNode;
                        yield new Str(String.valueOf(immutableObjectNumberNode.getValue()));
                    }
                    case 2 -> {
                        ImmutableNumberNode immutableNumberNode = (ImmutableNumberNode)immutableNode;
                        yield new Str(String.valueOf(immutableNumberNode.getValue()));
                    }
                    case 3 -> {
                        ImmutableObjectBooleanNode immutableObjectBooleanNode = (ImmutableObjectBooleanNode)immutableNode;
                        yield new Str(String.valueOf(immutableObjectBooleanNode.getValue()));
                    }
                    case 4 -> {
                        ImmutableBooleanNode immutableBooleanNode = (ImmutableBooleanNode)immutableNode;
                        yield new Str(String.valueOf(immutableBooleanNode.getValue()));
                    }
                    default -> throw new IllegalStateException("Value not supported.");
                };
                boolean isOfType = false;
                try {
                    if (this.type != Type.STR) {
                        AtomicUtil.toType((Atomic)strValue, this.type);
                    }
                    isOfType = true;
                }
                catch (SirixRuntimeException sirixRuntimeException) {
                    // empty catch block
                }
                if (isOfType) {
                    CASValue value = new CASValue((Atomic)strValue, this.type, pathNodeKey);
                    Optional<NodeReferences> textReferences = this.indexWriter.get(value, SearchMode.EQUAL);
                    if (textReferences.isPresent()) {
                        this.setNodeReferences(node, textReferences.get(), value);
                    } else {
                        this.setNodeReferences(node, new NodeReferences(), value);
                    }
                }
            }
            catch (PathException | SirixIOException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, CASValue value) throws SirixIOException {
        this.indexWriter.index(value, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

