/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.cas.xml;

import io.sirix.access.trx.node.xml.AbstractXmlNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.index.cas.CASIndexBuilder;
import io.sirix.node.immutable.xml.ImmutableAttributeNode;
import io.sirix.node.immutable.xml.ImmutableText;

final class XmlCASIndexBuilder
extends AbstractXmlNodeVisitor {
    private final CASIndexBuilder mIndexBuilderDelegate;
    private final XmlNodeReadOnlyTrx mRtx;

    XmlCASIndexBuilder(CASIndexBuilder indexBuilderDelegate, XmlNodeReadOnlyTrx rtx) {
        this.mIndexBuilderDelegate = indexBuilderDelegate;
        this.mRtx = rtx;
    }

    @Override
    public VisitResult visit(ImmutableText node) {
        this.mRtx.moveTo(node.getParentKey());
        long PCR = this.mRtx.isDocumentRoot() ? 0L : this.mRtx.getNameNode().getPathNodeKey();
        return this.mIndexBuilderDelegate.process(node, PCR);
    }

    @Override
    public VisitResult visit(ImmutableAttributeNode node) {
        long PCR = this.mRtx.isDocumentRoot() ? 0L : this.mRtx.getNameNode().getPathNodeKey();
        return this.mIndexBuilderDelegate.process(node, PCR);
    }
}

