/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import io.brackit.query.atomic.QNm;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.exception.SirixIOException;
import io.sirix.index.SearchMode;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.utils.LogWrapper;
import java.util.Optional;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class NameIndexBuilder {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(NameIndexBuilder.class));
    public Set<QNm> includes;
    public Set<QNm> excludes;
    public RBTreeWriter<QNm, NodeReferences> indexWriter;

    public NameIndexBuilder(Set<QNm> includes, Set<QNm> excludes, RBTreeWriter<QNm, NodeReferences> indexWriter) {
        this.includes = includes;
        this.excludes = excludes;
        this.indexWriter = indexWriter;
    }

    public VisitResultType build(QNm name, ImmutableNode node) {
        boolean excluded;
        boolean included = this.includes.isEmpty() || this.includes.contains(name);
        boolean bl = excluded = !this.excludes.isEmpty() && this.excludes.contains(name);
        if (!included || excluded) {
            return VisitResultType.CONTINUE;
        }
        Optional<NodeReferences> textReferences = this.indexWriter.get(name, SearchMode.EQUAL);
        try {
            textReferences.ifPresentOrElse(nodeReferences -> this.setNodeReferences(node, (NodeReferences)nodeReferences, name), () -> this.setNodeReferences(node, new NodeReferences(), name));
        }
        catch (SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return VisitResultType.CONTINUE;
    }

    private void setNodeReferences(ImmutableNode node, NodeReferences references, QNm name) {
        this.indexWriter.index(name, references.addNodeKey(node.getNodeKey()), RBTreeReader.MoveCursor.NO_MOVE);
    }
}

