/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.name;

import io.brackit.query.atomic.QNm;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexDef;
import io.sirix.index.IndexType;
import io.sirix.index.name.NameIndexBuilder;
import io.sirix.index.redblacktree.RBTreeWriter;
import io.sirix.index.redblacktree.keyvalue.NodeReferences;
import java.util.Objects;
import java.util.Set;

public final class NameIndexBuilderFactory {
    private final DatabaseType databaseType;

    public NameIndexBuilderFactory(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public NameIndexBuilder create(PageTrx pageTrx, IndexDef indexDefinition) {
        Set<QNm> includes = Objects.requireNonNull(indexDefinition.getIncluded());
        Set<QNm> excludes = Objects.requireNonNull(indexDefinition.getExcluded());
        assert (indexDefinition.getType() == IndexType.NAME);
        RBTreeWriter<QNm, NodeReferences> rbTreeWriter = RBTreeWriter.getInstance(this.databaseType, pageTrx, indexDefinition.getType(), indexDefinition.getID());
        return new NameIndexBuilder(includes, excludes, rbTreeWriter);
    }
}

