/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.sirix.index.Filter;
import io.sirix.index.path.PCRCollector;
import io.sirix.index.path.PCRValue;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.keyvalue.CASValue;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class PathFilter
implements Filter {
    private final boolean genericPath;
    private final Set<Path<QNm>> paths;
    private long maxKnownPCR;
    private Set<Long> pcrFilter;
    private final PCRCollector pcrCollector;

    public PathFilter(Set<Path<QNm>> paths, PCRCollector pcrCollector) {
        this.paths = Objects.requireNonNull(paths, "The paths must not be null.");
        this.pcrCollector = Objects.requireNonNull(pcrCollector, "The path class record collector must not be null.");
        this.genericPath = this.paths.isEmpty();
        PCRValue pcrValue = this.pcrCollector.getPCRsForPaths(this.paths);
        this.maxKnownPCR = pcrValue.getMaxPCR();
        this.pcrFilter = pcrValue.getPCRs();
    }

    public Set<Long> getPCRs() {
        return Collections.unmodifiableSet(this.pcrFilter);
    }

    public PCRCollector getPCRCollector() {
        return this.pcrCollector;
    }

    @Override
    public <K extends Comparable<? super K>> boolean filter(RBNodeKey<K> node) {
        long pcr;
        if (this.genericPath) {
            return true;
        }
        K key = node.getKey();
        if (key instanceof Long) {
            pcr = (Long)key;
        } else if (key instanceof CASValue) {
            pcr = ((CASValue)key).getPathNodeKey();
        } else {
            throw new IllegalStateException();
        }
        if (pcr > this.maxKnownPCR) {
            PCRValue pcrValue = this.pcrCollector.getPCRsForPaths(this.paths);
            this.maxKnownPCR = pcrValue.getMaxPCR();
            this.pcrFilter = pcrValue.getPCRs();
        }
        return this.pcrFilter.contains(pcr);
    }
}

