/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.path.summary;

import io.brackit.query.atomic.QNm;
import io.sirix.access.Utils;
import io.sirix.access.trx.node.NodeFactory;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.ChildAxis;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.LevelOrderAxis;
import io.sirix.axis.PostOrderAxis;
import io.sirix.axis.filter.FilterAxis;
import io.sirix.axis.filter.PathKindFilter;
import io.sirix.axis.filter.PathNameFilter;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.AbstractForwardingPathSummaryReader;
import io.sirix.index.path.summary.PathNode;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.node.NodeKind;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.immutable.xml.ImmutableElement;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNameNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.settings.Fixed;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;

public final class PathSummaryWriter<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractForwardingPathSummaryReader {
    private final PageTrx pageTrx;
    private final PathSummaryReader pathSummaryReader;
    private final NodeFactory nodeFactory;
    private final R nodeRtx;
    private final boolean storeChildCount;

    public PathSummaryWriter(PageTrx pageTrx, ResourceSession<R, ? extends NodeTrx> resMgr, NodeFactory nodeFactory, R rtx) {
        this.pageTrx = Objects.requireNonNull(pageTrx);
        this.pathSummaryReader = PathSummaryReader.getInstance(pageTrx, resMgr);
        this.nodeRtx = (NodeCursor)Objects.requireNonNull(rtx);
        this.nodeFactory = Objects.requireNonNull(nodeFactory);
        this.storeChildCount = resMgr.getResourceConfig().storeChildCount();
    }

    public PathSummaryReader getPathSummary() {
        return this.pathSummaryReader;
    }

    public long getPathNodeKey(QNm name, NodeKind pathKind) {
        long retVal;
        NodeKind kind = this.nodeRtx.getNode().getKind();
        int level = 0;
        if (kind == NodeKind.XML_DOCUMENT || kind == NodeKind.JSON_DOCUMENT) {
            this.pathSummaryReader.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
        } else {
            this.movePathSummary();
            level = this.pathSummaryReader.getLevel();
        }
        long nodeKey = this.pathSummaryReader.getNodeKey();
        FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.pathSummaryReader), new PathNameFilter(this.pathSummaryReader, pathKind == NodeKind.NAMESPACE ? name.getPrefix() : Utils.buildName(name)), new PathKindFilter(this.pathSummaryReader, pathKind));
        if (axis.hasNext()) {
            retVal = axis.nextLong();
            PathNode pathNode = (PathNode)this.pageTrx.prepareRecordForModification(retVal, IndexType.PATH_SUMMARY, 0);
            pathNode.incrementReferenceCount();
            this.pathSummaryReader.putMapping(pathNode.getNodeKey(), pathNode);
        } else {
            assert (nodeKey == this.pathSummaryReader.getNodeKey());
            this.insertPathAsFirstChild(name, pathKind, level + 1);
            retVal = this.pathSummaryReader.getNodeKey();
        }
        return retVal;
    }

    private void movePathSummary() {
        if (this.nodeRtx.getKind() == NodeKind.OBJECT) {
            this.nodeRtx.moveToParent();
        }
        if (this.nodeRtx.getKind() == NodeKind.OBJECT_KEY) {
            this.pathSummaryReader.moveTo(((ImmutableObjectKeyNode)this.nodeRtx.getNode()).getPathNodeKey());
        } else if (this.nodeRtx.getKind() == NodeKind.ARRAY) {
            this.pathSummaryReader.moveTo(((ImmutableArrayNode)this.nodeRtx.getNode()).getPathNodeKey());
        } else if (this.nodeRtx.getNode() instanceof ImmutableNameNode) {
            this.pathSummaryReader.moveTo(((ImmutableNameNode)this.nodeRtx.getNode()).getPathNodeKey());
        } else {
            throw new IllegalStateException();
        }
    }

    public PathSummaryWriter<R> insertPathAsFirstChild(QNm name, NodeKind pathKind, int level) {
        long parentKey = this.pathSummaryReader.getNodeKey();
        long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
        long rightSibKey = this.pathSummaryReader.getFirstChildKey();
        PathNode node = this.nodeFactory.createPathNode(parentKey, leftSibKey, rightSibKey, name, pathKind, level);
        this.pathSummaryReader.removeFromCache(name);
        this.pathSummaryReader.putMapping(node.getNodeKey(), node);
        this.pathSummaryReader.moveTo(node.getNodeKey());
        this.adaptForInsert(node);
        this.pathSummaryReader.moveTo(node.getNodeKey());
        this.pathSummaryReader.putQNameMapping(node, name);
        return this;
    }

    private void adaptForInsert(Node newNode) {
        assert (newNode != null);
        if (newNode instanceof StructNode) {
            StructNode strucNode = (StructNode)newNode;
            StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(newNode.getParentKey(), IndexType.PATH_SUMMARY, 0);
            if (this.storeChildCount) {
                parent.incrementChildCount();
            }
            parent.setFirstChildKey(newNode.getNodeKey());
            this.pathSummaryReader.putMapping(parent.getNodeKey(), parent);
            if (strucNode.hasRightSibling()) {
                StructNode rightSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(strucNode.getRightSiblingKey(), IndexType.PATH_SUMMARY, 0);
                rightSiblingNode.setLeftSiblingKey(newNode.getNodeKey());
                this.pathSummaryReader.putMapping(rightSiblingNode.getNodeKey(), rightSiblingNode);
            }
            if (strucNode.hasLeftSibling()) {
                StructNode leftSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(strucNode.getLeftSiblingKey(), IndexType.PATH_SUMMARY, 0);
                leftSiblingNode.setRightSiblingKey(newNode.getNodeKey());
                this.pathSummaryReader.putMapping(leftSiblingNode.getNodeKey(), leftSiblingNode);
            }
        }
    }

    public void adaptPathForChangedNode(ImmutableNameNode node, QNm name, int uriKey, int prefixKey, int localNameKey, OPType type) {
        this.movePathSummary();
        long oldPathNodeKey = this.pathSummaryReader.getNodeKey();
        if (type == OPType.SETNAME && this.pathSummaryReader.getReferences() == 1) {
            this.moveSummaryGetLevel(node);
            FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.pathSummaryReader), new PathNameFilter(this.pathSummaryReader, Utils.buildName(name)), new PathKindFilter(this.pathSummaryReader, node.getKind()));
            if (axis.hasNext()) {
                axis.nextLong();
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.pathSummaryReader.moveTo(nodeKey);
                this.processFoundPathNode(oldPathNodeKey, this.pathSummaryReader.getNodeKey(), node.getNodeKey(), name, uriKey, prefixKey, localNameKey);
            } else if (this.pathSummaryReader.getKind() == NodeKind.XML_DOCUMENT || this.pathSummaryReader.getKind() == NodeKind.JSON_DOCUMENT) {
                this.insertPathAsFirstChild(name, node.getKind(), 1);
            } else {
                this.pathSummaryReader.moveTo(oldPathNodeKey);
                PathNode pathNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
                pathNode.setPrefixKey(prefixKey);
                pathNode.setLocalNameKey(localNameKey);
                pathNode.setURIKey(uriKey);
                pathNode.setName(name);
                this.pathSummaryReader.putMapping(pathNode.getNodeKey(), pathNode);
                this.pathSummaryReader.putQNameMapping(pathNode, name);
            }
        } else {
            int level = this.moveSummaryGetLevel(node);
            FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new ChildAxis(this.pathSummaryReader), new PathNameFilter(this.pathSummaryReader, Utils.buildName(name)), new PathKindFilter(this.pathSummaryReader, node.getKind()));
            if (axis.hasNext()) {
                axis.nextLong();
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.pathSummaryReader.moveTo(nodeKey);
                this.processFoundPathNode(oldPathNodeKey, this.pathSummaryReader.getNodeKey(), node.getNodeKey(), name, uriKey, prefixKey, localNameKey);
            } else {
                long nodeKey = this.decrementReferenceCountOrRemove(node);
                this.pathSummaryReader.moveTo(nodeKey);
                boolean firstRun = true;
                DescendantAxis descendants = new DescendantAxis((NodeCursor)this.nodeRtx, IncludeSelf.YES);
                while (descendants.hasNext()) {
                    descendants.nextLong();
                    if (this.nodeRtx.getKind() != NodeKind.ELEMENT && this.nodeRtx.getKind() != NodeKind.OBJECT_KEY) continue;
                    if (firstRun) {
                        this.insertPathAsFirstChild(name, this.nodeRtx.getKind(), ++level);
                        nodeKey = this.pathSummaryReader.getNodeKey();
                    } else {
                        this.insertPathAsFirstChild(((NodeReadOnlyTrx)this.nodeRtx).getName(), this.nodeRtx.getKind(), ++level);
                    }
                    this.resetPathNodeKey(((NodeReadOnlyTrx)this.nodeRtx).getNodeKey(), this.nodeRtx.getKind());
                    R r = this.nodeRtx;
                    if (r instanceof XmlNodeReadOnlyTrx) {
                        int i;
                        XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)r;
                        int nsps = rtx.getNamespaceCount();
                        for (i = 0; i < nsps; ++i) {
                            rtx.moveToNamespace(i);
                            this.insertPathAsFirstChild(rtx.getName(), NodeKind.NAMESPACE, level + 1);
                            this.resetPathNodeKey(rtx.getNodeKey(), NodeKind.NAMESPACE);
                            rtx.moveToParent();
                            this.pathSummaryReader.moveToParent();
                        }
                        int atts = rtx.getAttributeCount();
                        for (i = 0; i < atts; ++i) {
                            rtx.moveToAttribute(i);
                            this.insertPathAsFirstChild(rtx.getName(), NodeKind.ATTRIBUTE, level + 1);
                            this.resetPathNodeKey(rtx.getNodeKey(), NodeKind.ATTRIBUTE);
                            rtx.moveToParent();
                            this.pathSummaryReader.moveToParent();
                        }
                    }
                    if (firstRun) {
                        firstRun = false;
                        continue;
                    }
                    this.pathSummaryReader.moveToParent();
                    --level;
                }
                this.pathSummaryReader.moveTo(nodeKey);
            }
        }
    }

    private long decrementReferenceCountOrRemove(ImmutableNameNode node) {
        long nodeKey = this.pathSummaryReader.getNodeKey();
        ((NodeReadOnlyTrx)this.nodeRtx).moveTo(node.getNodeKey());
        PostOrderAxis descendants = new PostOrderAxis((NodeCursor)this.nodeRtx, IncludeSelf.YES);
        while (descendants.hasNext()) {
            descendants.nextLong();
            if (this.nodeRtx.getKind() == NodeKind.ELEMENT) {
                int i;
                XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.nodeRtx;
                ImmutableElement element = (ImmutableElement)rtx.getNode();
                int nsps = element.getNamespaceCount();
                for (i = 0; i < nsps; ++i) {
                    rtx.moveToNamespace(i);
                    this.deleteOrDecrement();
                    rtx.moveToParent();
                }
                int atts = element.getAttributeCount();
                for (i = 0; i < atts; ++i) {
                    rtx.moveToAttribute(i);
                    this.deleteOrDecrement();
                    rtx.moveToParent();
                }
            }
            this.deleteOrDecrement();
        }
        return nodeKey;
    }

    private void processFoundPathNode(@NonNegative long oldPathNodeKey, @NonNegative long newPathNodeKey, @NonNegative long oldNodeKey, QNm name, int uriKey, int prefixKey, int localNameKey) {
        ((NodeReadOnlyTrx)this.nodeRtx).moveTo(oldNodeKey);
        PathNode currNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
        currNode.setReferenceCount(currNode.getReferences() + 1);
        currNode.setLocalNameKey(localNameKey);
        currNode.setPrefixKey(prefixKey);
        currNode.setURIKey(uriKey);
        currNode.setName(name);
        this.pathSummaryReader.putMapping(currNode.getNodeKey(), currNode);
        this.pathSummaryReader.putQNameMapping(currNode, name);
        long pathNodeKey = currNode.getNodeKey();
        this.processElementNonStructuralNodes(pathNodeKey, 0);
        boolean movedNodeCursorToFirstChild = this.nodeRtx.moveToFirstChild();
        boolean movedPathSummaryToFirstChild = this.pathSummaryReader.moveToFirstChild();
        if (movedNodeCursorToFirstChild && movedPathSummaryToFirstChild) {
            long pathRootNodeKey = this.pathSummaryReader.getNodeKey();
            LevelOrderAxis levelOrderAxis = new LevelOrderAxis.Builder((NodeCursor)this.nodeRtx).includeSelf().build();
            while (levelOrderAxis.hasNext()) {
                levelOrderAxis.nextLong();
                if (!(this.nodeRtx.getNode() instanceof ImmutableNameNode)) continue;
                this.adaptPathSummary(levelOrderAxis.getCurrentLevel(), pathRootNodeKey);
                this.processElementNonStructuralNodes(pathRootNodeKey, levelOrderAxis.getCurrentLevel());
            }
        } else if (movedNodeCursorToFirstChild) {
            LevelOrderAxis levelOrderAxis = new LevelOrderAxis.Builder((NodeCursor)this.nodeRtx).includeSelf().build();
            while (levelOrderAxis.hasNext()) {
                levelOrderAxis.nextLong();
                if (!(this.nodeRtx.getNode() instanceof ImmutableNameNode)) continue;
                this.adaptForNewPathNode();
                this.processElementNonStructuralNodes(this.pathSummaryReader.getNodeKey(), levelOrderAxis.getCurrentLevel());
            }
        } else if (movedPathSummaryToFirstChild) {
            this.pathSummaryReader.moveToParent();
        }
        this.pathSummaryReader.moveTo(pathNodeKey);
    }

    private void processElementNonStructuralNodes(long pathRootNodeKey, int level) {
        if (this.nodeRtx.getNode().getKind() == NodeKind.ELEMENT) {
            int i;
            XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.nodeRtx;
            ImmutableElement element = (ImmutableElement)rtx.getNode();
            int nspCount = element.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                rtx.moveToNamespace(i);
                this.adaptPathSummary(level, pathRootNodeKey);
                rtx.moveToParent();
            }
            int attCount = element.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                this.adaptPathSummary(level, pathRootNodeKey);
                rtx.moveToParent();
            }
        }
    }

    private void adaptPathSummary(int level, long newPathNodeKey) {
        FilterAxis<PathSummaryReader> axis = new FilterAxis<PathSummaryReader>(new LevelOrderAxis.Builder(this.pathSummaryReader).filterLevel(level).includeSelf().build(), new PathNameFilter(this.pathSummaryReader, Utils.buildName(((NodeReadOnlyTrx)this.nodeRtx).getName())), new PathKindFilter(this.pathSummaryReader, this.nodeRtx.getKind()));
        if (axis.hasNext()) {
            axis.nextLong();
            this.adaptForFoundPathNode();
        } else {
            this.adaptForNewPathNode();
        }
        this.pathSummaryReader.moveTo(newPathNodeKey);
    }

    private void adaptForNewPathNode() {
        this.moveToPathNodeOfParentNode();
        this.insertPathAsFirstChild(((NodeReadOnlyTrx)this.nodeRtx).getName(), this.nodeRtx.getKind(), this.pathSummaryReader.getLevel() + 1);
        this.setReferenceCountToOne();
        this.setNewPathNodeKey();
    }

    private void moveToPathNodeOfParentNode() {
        long pathNodeKey;
        long nodeKey = ((NodeReadOnlyTrx)this.nodeRtx).getNodeKey();
        R r = this.nodeRtx;
        if (r instanceof XmlNodeReadOnlyTrx) {
            XmlNodeReadOnlyTrx xmlNodeReadOnlyTrx = (XmlNodeReadOnlyTrx)r;
            xmlNodeReadOnlyTrx.moveToParent();
            pathNodeKey = xmlNodeReadOnlyTrx.getPathNodeKey();
        } else {
            r = this.nodeRtx;
            if (r instanceof JsonNodeReadOnlyTrx) {
                JsonNodeReadOnlyTrx jsonNodeReadOnlyTrx = (JsonNodeReadOnlyTrx)r;
                jsonNodeReadOnlyTrx.moveToParent();
                pathNodeKey = jsonNodeReadOnlyTrx.getPathNodeKey();
            } else {
                throw new IllegalStateException("Node transaction kind not known.");
            }
        }
        this.pathSummaryReader.moveTo(pathNodeKey);
        ((NodeReadOnlyTrx)this.nodeRtx).moveTo(nodeKey);
    }

    private void adaptForFoundPathNode() {
        this.increaseReferenceCount();
        this.resetPathNodeKey(((NodeReadOnlyTrx)this.nodeRtx).getNodeKey(), this.nodeRtx.getKind());
    }

    private void setNewPathNodeKey() {
        NameNode node = (NameNode)this.pageTrx.prepareRecordForModification(((NodeReadOnlyTrx)this.nodeRtx).getNodeKey(), IndexType.DOCUMENT, -1);
        node.setPathNodeKey(this.pathSummaryReader.getNodeKey());
    }

    private void setReferenceCountToOne() {
        PathNode currNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
        currNode.setReferenceCount(1);
        this.pathSummaryReader.putMapping(currNode.getNodeKey(), currNode);
    }

    private void increaseReferenceCount() {
        PathNode currNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
        currNode.setReferenceCount(currNode.getReferences() + 1);
        this.pathSummaryReader.putMapping(currNode.getNodeKey(), currNode);
    }

    private int moveSummaryGetLevel(ImmutableNode node) {
        assert (node != null);
        this.nodeRtx.moveToParent();
        if (this.nodeRtx.getKind() == NodeKind.OBJECT) {
            this.nodeRtx.moveToParent();
        }
        int level = 0;
        if (this.nodeRtx.getKind() == NodeKind.XML_DOCUMENT || this.nodeRtx.getKind() == NodeKind.JSON_DOCUMENT) {
            this.pathSummaryReader.moveToDocumentRoot();
        } else {
            this.movePathSummary();
            level = this.pathSummaryReader.getLevel();
        }
        ((NodeReadOnlyTrx)this.nodeRtx).moveTo(node.getNodeKey());
        return level;
    }

    private void resetPathNodeKey(@NonNegative long nodeKey, NodeKind nodeKind) {
        if (nodeKind == NodeKind.ATTRIBUTE || nodeKind == NodeKind.ELEMENT || nodeKind == NodeKind.NAMESPACE) {
            NameNode currNode = (NameNode)this.pageTrx.prepareRecordForModification(nodeKey, IndexType.DOCUMENT, -1);
            currNode.setPathNodeKey(this.pathSummaryReader.getNodeKey());
        } else {
            ObjectKeyNode currNode = (ObjectKeyNode)this.pageTrx.prepareRecordForModification(nodeKey, IndexType.DOCUMENT, -1);
            currNode.setPathNodeKey(this.pathSummaryReader.getNodeKey());
        }
    }

    private void removePathSummaryNode(RemoveSubtreePath remove) {
        this.pathSummaryReader.clearCache();
        if (remove == RemoveSubtreePath.YES) {
            PostOrderAxis axis = new PostOrderAxis(this.pathSummaryReader);
            while (axis.hasNext()) {
                axis.nextLong();
                this.pathSummaryReader.removeMapping(this.pathSummaryReader.getNodeKey());
                this.pathSummaryReader.removeQNameMapping(this.pathSummaryReader.getPathNode(), this.pathSummaryReader.getName());
                this.pageTrx.removeRecord(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
            }
        }
        if (this.pathSummaryReader.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getLeftSiblingKey(), IndexType.PATH_SUMMARY, 0);
            leftSibling.setRightSiblingKey(this.pathSummaryReader.getRightSiblingKey());
            this.pathSummaryReader.putMapping(leftSibling.getNodeKey(), leftSibling);
        }
        if (this.pathSummaryReader.hasRightSibling()) {
            StructNode rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getRightSiblingKey(), IndexType.PATH_SUMMARY, 0);
            rightSibling.setLeftSiblingKey(this.pathSummaryReader.getLeftSiblingKey());
            this.pathSummaryReader.putMapping(rightSibling.getNodeKey(), rightSibling);
        }
        StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getParentKey(), IndexType.PATH_SUMMARY, 0);
        if (!this.pathSummaryReader.hasLeftSibling()) {
            parent.setFirstChildKey(this.pathSummaryReader.getRightSiblingKey());
        }
        if (this.storeChildCount) {
            parent.decrementChildCount();
        }
        this.pathSummaryReader.putMapping(parent.getNodeKey(), parent);
        this.pathSummaryReader.removeMapping(this.pathSummaryReader.getNodeKey());
        this.pathSummaryReader.removeQNameMapping(this.pathSummaryReader.getPathNode(), this.pathSummaryReader.getName());
        this.pageTrx.removeRecord(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
    }

    private void deleteOrDecrement() {
        if (this.nodeRtx.getNode() instanceof ImmutableNameNode) {
            this.movePathSummary();
            if (this.pathSummaryReader.getReferences() == 1) {
                this.removePathSummaryNode(RemoveSubtreePath.NO);
            } else {
                PathNode pathNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
                pathNode.decrementReferenceCount();
                this.pathSummaryReader.putMapping(pathNode.getNodeKey(), pathNode);
            }
        }
    }

    public void remove(ImmutableNameNode node) {
        if (this.pathSummaryReader.moveTo(node.getPathNodeKey())) {
            if (this.pathSummaryReader.getReferences() == 1) {
                this.removePathSummaryNode(RemoveSubtreePath.YES);
            } else {
                assert (this.pathSummaryReader.getReferences() > 1);
                PathNode pathNode = (PathNode)this.pageTrx.prepareRecordForModification(this.pathSummaryReader.getNodeKey(), IndexType.PATH_SUMMARY, 0);
                pathNode.decrementReferenceCount();
                this.pathSummaryReader.putMapping(pathNode.getNodeKey(), pathNode);
            }
        }
    }

    @Override
    protected PathSummaryReader delegate() {
        return this.pathSummaryReader;
    }

    public static enum OPType {
        MOVED_ON_SAME_LEVEL,
        MOVED,
        SETNAME;

    }

    private static enum RemoveSubtreePath {
        YES,
        NO;

    }
}

