/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.sirix.api.NodeCursor;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.cache.Cache;
import io.sirix.cache.RBIndexKey;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.index.SearchMode;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.RBNodeValue;
import io.sirix.index.redblacktree.interfaces.References;
import io.sirix.node.NodeKind;
import io.sirix.node.NullNode;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.settings.Fixed;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RBTreeReader<K extends Comparable<? super K>, V extends References>
implements NodeCursor {
    private final Cache<RBIndexKey, Node> cache;
    final IndexType indexType;
    private final int indexNumber;
    private final int revisionNumber;
    private boolean isClosed;
    private Node currentNode;
    final PageReadOnlyTrx pageReadOnlyTrx;
    final int index;

    public static <K extends Comparable<? super K>, V extends References> RBTreeReader<K, V> getInstance(Cache<RBIndexKey, Node> cache, PageReadOnlyTrx pageReadTrx, IndexType type, @NonNegative int index) {
        return new RBTreeReader<K, V>(cache, pageReadTrx, type, index);
    }

    private RBTreeReader(Cache<RBIndexKey, Node> cache, PageReadOnlyTrx pageReadOnlyTrx, IndexType indexType, int indexNumber) {
        this.cache = Objects.requireNonNull(cache);
        this.pageReadOnlyTrx = Objects.requireNonNull(pageReadOnlyTrx);
        this.indexType = Objects.requireNonNull(indexType);
        this.indexNumber = indexNumber;
        this.revisionNumber = pageReadOnlyTrx.getRevisionNumber();
        this.isClosed = false;
        this.index = indexNumber;
        this.currentNode = (Node)this.pageReadOnlyTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), indexType, indexNumber);
        if (this.currentNode == null) {
            throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
        }
        if (!(pageReadOnlyTrx instanceof PageTrx)) {
            RBNodeIterator it = new RBNodeIterator(0L);
            while (it.hasNext()) {
                RBNodeKey node = (RBNodeKey)it.next();
                assert (node.getNodeKey() != 0L);
                this.cache.put(new RBIndexKey(node.getNodeKey(), this.revisionNumber, indexType, indexNumber), this.getCurrentNodeAsRBNodeKey());
            }
            this.setCurrentNode(this.currentNode);
        }
    }

    public void dump(PrintStream out) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((StructNode)this.getNode()).hasFirstChild()) {
            return;
        }
        this.moveToFirstChild();
        this.internalDump(out);
    }

    private void internalDump(PrintStream out) {
        out.println(this.getCurrentNodeAsRBNodeKey());
        long nodeKey = this.getCurrentNodeAsRBNodeKey().getNodeKey();
        if (this.getCurrentNodeAsRBNodeKey().hasLeftChild()) {
            this.moveToFirstChild();
            this.internalDump(out);
        }
        this.moveTo(nodeKey);
        if (this.getCurrentNodeAsRBNodeKey().hasRightChild()) {
            this.moveToLastChild();
            this.internalDump(out);
        }
    }

    public RBNodeKey<K> getCurrentNodeAsRBNodeKey() {
        this.assertNotClosed();
        Node node = this.currentNode;
        if (node instanceof RBNodeKey) {
            RBNodeKey rbNodeKey = (RBNodeKey)node;
            return rbNodeKey;
        }
        return null;
    }

    public RBNodeValue<V> getCurrentNodeAsRBNodeValue() {
        this.assertNotClosed();
        Node node = this.currentNode;
        if (node instanceof RBNodeValue) {
            RBNodeValue rbNodeValue = (RBNodeValue)node;
            return rbNodeValue;
        }
        return null;
    }

    Node setCurrentNode(Node node) {
        this.assertNotClosed();
        this.currentNode = node;
        return node;
    }

    public Optional<V> get(long startNodeKey, K key, SearchMode mode) {
        this.assertNotClosed();
        boolean movedToStartNode = this.moveTo(startNodeKey);
        if (!movedToStartNode) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
        return this.getNode(key, mode, node);
    }

    private @NonNull Optional<V> getNode(K key, SearchMode mode, RBNodeKey<K> node) {
        boolean moved;
        do {
            int c;
            if ((c = mode.compare(key, node.getKey())) == 0) {
                long valueNodeKey = node.getValueNodeKey();
                this.moveTo(valueNodeKey);
                Optional<References> value = Optional.ofNullable((References)this.getCurrentNodeAsRBNodeValue().getValue());
                this.setCurrentNode(node);
                return value;
            }
            if (c < 0) {
                if (node.getLeftChild() != null) {
                    this.currentNode = node = node.getLeftChild();
                    moved = true;
                    continue;
                }
                if (node.hasLeftChild()) {
                    RBNodeKey<K> rBNodeKey = node = this.pageReadOnlyTrx instanceof PageTrx ? null : (RBNodeKey<K>)this.cache.get(new RBIndexKey(node.getLeftChildKey(), this.revisionNumber, this.indexType, this.indexNumber));
                    if (node == null) {
                        moved = this.moveToFirstChild();
                        if (!moved) continue;
                        node = this.getCurrentNodeAsRBNodeKey();
                        continue;
                    }
                    this.currentNode = node;
                    moved = true;
                    continue;
                }
                moved = false;
                continue;
            }
            if (node.getRightChild() != null) {
                this.currentNode = node = node.getRightChild();
                moved = true;
                continue;
            }
            if (node.hasRightChild()) {
                RBNodeKey<K> rBNodeKey = node = this.pageReadOnlyTrx instanceof PageTrx ? null : (RBNodeKey<K>)this.cache.get(new RBIndexKey(node.getRightChildKey(), this.revisionNumber, this.indexType, this.indexNumber));
                if (node == null) {
                    moved = this.moveToLastChild();
                    if (!moved) continue;
                    node = this.getCurrentNodeAsRBNodeKey();
                    continue;
                }
                this.currentNode = node;
                moved = true;
                continue;
            }
            moved = false;
        } while (moved);
        return Optional.empty();
    }

    public Optional<V> get(K key, SearchMode mode) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((StructNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
        return this.getNode(key, mode, node);
    }

    public Optional<RBNodeKey<K>> getCurrentNodeAsRBNodeKey(long startNodeKey, K key, SearchMode mode) {
        this.assertNotClosed();
        boolean movedToStartNode = this.moveTo(startNodeKey);
        if (!movedToStartNode) {
            return Optional.empty();
        }
        RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
        return this.getTheSearchedNode(key, mode, node);
    }

    private @NonNull Optional<RBNodeKey<K>> getTheSearchedNode(K key, SearchMode mode, RBNodeKey<K> node) {
        while (true) {
            boolean moved;
            int c = key.compareTo(node.getKey());
            if (mode != SearchMode.EQUAL && mode.compare(key, node.getKey()) == 0) {
                return Optional.ofNullable(node);
            }
            if (c == 0 && mode == SearchMode.EQUAL) {
                return Optional.ofNullable(node);
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild() : this.moveToLastChild();
            if (!moved) break;
            node = this.getCurrentNodeAsRBNodeKey();
        }
        return Optional.empty();
    }

    public Optional<RBNodeKey<K>> getCurrentNodeAsRBNodeKey(K key, SearchMode mode) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((StructNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
        return this.getTheSearchedNode(key, mode, node);
    }

    public Optional<RBNodeKey<K>> getCurrentNodeAsRBNodeKey(K key, SearchMode mode, Comparator<? super K> comp) {
        this.assertNotClosed();
        this.moveToDocumentRoot();
        if (!((StructNode)this.getNode()).hasFirstChild()) {
            return Optional.empty();
        }
        this.moveToFirstChild();
        RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
        while (true) {
            boolean moved;
            int c = key.compareTo(node.getKey());
            if (mode.compare(key, node.getKey(), comp) == 0) {
                return Optional.ofNullable(node);
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild() : this.moveToLastChild();
            if (!moved) break;
            node = this.getCurrentNodeAsRBNodeKey();
        }
        return Optional.empty();
    }

    public long size() {
        this.moveToDocumentRoot();
        return this.getStructuralNode().getDescendantCount();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Tree reader is already closed.");
        }
    }

    private StructNode getStructuralNode() {
        this.assertNotClosed();
        if (this.currentNode instanceof StructNode) {
            return (StructNode)this.currentNode;
        }
        return new NullNode(this.currentNode);
    }

    @Override
    public boolean hasNode(long key) {
        this.assertNotClosed();
        long currKey = this.currentNode.getNodeKey();
        boolean moved = this.moveTo(key);
        boolean movedCursor = this.moveTo(currKey);
        assert (movedCursor) : "Must be movable back!";
        return moved;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.currentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        if (this.currentNode instanceof RBNodeKey) {
            return this.getCurrentNodeAsRBNodeKey().hasRightChild();
        }
        return false;
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    @Override
    public boolean moveTo(long nodeKey) {
        Node newNode;
        this.assertNotClosed();
        if (nodeKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return false;
        }
        Node oldNode = this.currentNode;
        try {
            newNode = (Node)this.pageReadOnlyTrx.getRecord(nodeKey, this.indexType, this.index);
        }
        catch (SirixIOException e) {
            newNode = null;
        }
        if (newNode == null) {
            this.currentNode = oldNode;
            return false;
        }
        this.currentNode = newNode;
        return true;
    }

    @Override
    public boolean moveToDocumentRoot() {
        this.assertNotClosed();
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    @Override
    public boolean moveToParent() {
        this.assertNotClosed();
        return this.moveTo(this.currentNode.getParentKey());
    }

    @Override
    public boolean moveToFirstChild() {
        this.assertNotClosed();
        if (this.currentNode instanceof RBNodeKey) {
            RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
            if (!node.hasLeftChild()) {
                return false;
            }
            boolean move = this.moveTo(node.getLeftChildKey());
            RBNodeKey currentNode = (RBNodeKey)this.currentNode;
            node.setLeftChild(currentNode);
            currentNode.setParent(node);
            return move;
        }
        return this.moveTo(((StructNode)this.currentNode).getFirstChildKey());
    }

    @Override
    public boolean moveToLastChild() {
        this.assertNotClosed();
        if (this.currentNode instanceof RBNodeKey) {
            RBNodeKey<K> node = this.getCurrentNodeAsRBNodeKey();
            if (!node.hasRightChild()) {
                return false;
            }
            boolean move = this.moveTo(node.getRightChildKey());
            RBNodeKey currentNode = (RBNodeKey)this.currentNode;
            node.setRightChild(currentNode);
            currentNode.setParent(node);
            return move;
        }
        return false;
    }

    @Override
    public boolean moveToPrevious() {
        this.assertNotClosed();
        return this.moveToParent();
    }

    @Override
    public boolean moveToNext() {
        this.assertNotClosed();
        if (this.currentNode instanceof RBNodeKey) {
            RBNodeKey node = (RBNodeKey)this.currentNode;
            if (node.hasLeftChild()) {
                this.moveToFirstChild();
            } else if (node.hasRightChild()) {
                this.moveToLastChild();
            } else {
                do {
                    this.moveToParent();
                } while (this.getNode() instanceof RBNodeKey && !this.hasLastChild());
                if (this.getNode() instanceof RBNodeKey) {
                    this.moveToLastChild();
                    return true;
                }
                return false;
            }
        }
        return this.moveToFirstChild();
    }

    @Override
    public boolean moveToLeftSibling() {
        this.assertNotClosed();
        return false;
    }

    @Override
    public boolean moveToRightSibling() {
        this.assertNotClosed();
        return false;
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.currentNode.getNodeKey();
    }

    @Override
    public NodeKind getRightSiblingKind() {
        this.assertNotClosed();
        return NodeKind.UNKNOWN;
    }

    @Override
    public NodeKind getLeftSiblingKind() {
        this.assertNotClosed();
        return NodeKind.UNKNOWN;
    }

    @Override
    public NodeKind getFirstChildKind() {
        NodeKind firstChildKind;
        this.assertNotClosed();
        if (this.moveToFirstChild()) {
            firstChildKind = this.getNode().getKind();
            this.moveToParent();
        } else {
            firstChildKind = NodeKind.UNKNOWN;
        }
        return firstChildKind;
    }

    @Override
    public NodeKind getLastChildKind() {
        NodeKind lastChildKind;
        this.assertNotClosed();
        if (this.moveToLastChild()) {
            lastChildKind = this.getNode().getKind();
            this.moveToParent();
        } else {
            lastChildKind = NodeKind.UNKNOWN;
        }
        return lastChildKind;
    }

    @Override
    public NodeKind getParentKind() {
        this.assertNotClosed();
        if (this.hasParent()) {
            long nodeKey = this.currentNode.getNodeKey();
            this.moveToParent();
            NodeKind parentKind = this.getKind();
            this.moveTo(nodeKey);
            return parentKind;
        }
        return NodeKind.UNKNOWN;
    }

    @Override
    public NodeKind getKind() {
        this.assertNotClosed();
        return this.currentNode.getKind();
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        return this.currentNode;
    }

    @Override
    public boolean moveToNextFollowing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getFirstChildKey() {
        this.assertNotClosed();
        return ((StructNode)this.currentNode).getFirstChildKey();
    }

    @Override
    public long getLastChildKey() {
        this.assertNotClosed();
        return ((StructNode)this.currentNode).getLastChildKey();
    }

    @Override
    public long getParentKey() {
        return this.getNode().getParentKey();
    }

    public final class RBNodeIterator
    extends AbstractIterator<RBNodeKey<K>> {
        private boolean first = true;
        private final Deque<Long> keys = new ArrayDeque<Long>();
        private final long key;

        public RBNodeIterator(long nodeKey) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
            this.key = nodeKey;
        }

        protected RBNodeKey<K> computeNext() {
            if (!this.first) {
                if (!this.keys.isEmpty()) {
                    RBTreeReader.this.moveTo(this.keys.pop());
                    RBNodeKey node = RBTreeReader.this.getCurrentNodeAsRBNodeKey();
                    this.stackOperation(node);
                    return node;
                }
                return (RBNodeKey)this.endOfData();
            }
            this.first = false;
            boolean moved = RBTreeReader.this.moveTo(this.key);
            if (this.key == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                moved = RBTreeReader.this.moveToFirstChild();
            }
            if (moved) {
                RBNodeKey node = RBTreeReader.this.getCurrentNodeAsRBNodeKey();
                this.stackOperation(node);
                return node;
            }
            return (RBNodeKey)this.endOfData();
        }

        private void stackOperation(RBNodeKey<K> node) {
            if (node.hasRightChild()) {
                RBTreeReader.this.moveToLastChild();
                RBNodeKey right = RBTreeReader.this.getCurrentNodeAsRBNodeKey();
                this.keys.push(right.getNodeKey());
            }
            RBTreeReader.this.moveTo(node.getNodeKey());
            if (node.hasLeftChild()) {
                RBTreeReader.this.moveToFirstChild();
                RBNodeKey left = RBTreeReader.this.getCurrentNodeAsRBNodeKey();
                this.keys.push(left.getNodeKey());
            }
        }
    }

    public static enum MoveCursor {
        TO_DOCUMENT_ROOT,
        NO_MOVE;

    }
}

