/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree;

import com.google.common.base.Preconditions;
import io.sirix.access.DatabaseType;
import io.sirix.access.trx.node.AbstractForwardingNodeCursor;
import io.sirix.api.NodeCursor;
import io.sirix.api.PageTrx;
import io.sirix.cache.PageContainer;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.index.SearchMode;
import io.sirix.index.redblacktree.RBNodeKey;
import io.sirix.index.redblacktree.RBNodeValue;
import io.sirix.index.redblacktree.RBTreeReader;
import io.sirix.index.redblacktree.interfaces.References;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.interfaces.StructNode;
import io.sirix.page.CASPage;
import io.sirix.page.NamePage;
import io.sirix.page.PageReference;
import io.sirix.page.PathPage;
import io.sirix.page.RevisionRootPage;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public final class RBTreeWriter<K extends Comparable<? super K>, V extends References>
extends AbstractForwardingNodeCursor {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(RBTreeWriter.class));
    private final RBTreeReader<K, V> rbTreeReader;
    private final PageTrx pageTrx;

    private RBTreeWriter(DatabaseType databaseType, PageTrx pageTrx, IndexType type, @NonNegative int index) {
        try {
            RevisionRootPage revisionRootPage = pageTrx.getActualRevisionRootPage();
            switch (type) {
                case PATH: {
                    PathPage pathPage = pageTrx.getPathPage(revisionRootPage);
                    PageReference reference = revisionRootPage.getPathPageReference();
                    pageTrx.appendLogRecord(reference, PageContainer.getInstance(pathPage, pathPage));
                    pathPage.createPathIndexTree(databaseType, pageTrx, index, pageTrx.getLog());
                    break;
                }
                case CAS: {
                    CASPage casPage = pageTrx.getCASPage(revisionRootPage);
                    PageReference reference = revisionRootPage.getCASPageReference();
                    pageTrx.appendLogRecord(reference, PageContainer.getInstance(casPage, casPage));
                    casPage.createCASIndexTree(databaseType, pageTrx, index, pageTrx.getLog());
                    break;
                }
                case NAME: {
                    NamePage namePage = pageTrx.getNamePage(revisionRootPage);
                    PageReference reference = revisionRootPage.getNamePageReference();
                    pageTrx.appendLogRecord(reference, PageContainer.getInstance(namePage, namePage));
                    namePage.createNameIndexTree(databaseType, pageTrx, index, pageTrx.getLog());
                    break;
                }
            }
        }
        catch (SirixIOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        this.rbTreeReader = RBTreeReader.getInstance(pageTrx.getResourceSession().getIndexCache(), pageTrx, type, index);
        this.pageTrx = pageTrx;
    }

    public static <K extends Comparable<? super K>, V extends References> RBTreeWriter<K, V> getInstance(DatabaseType databaseType, PageTrx pageWriteTrx, IndexType type, int index) {
        return new RBTreeWriter<K, V>(databaseType, pageWriteTrx, type, index);
    }

    public V index(K key, V value, RBTreeReader.MoveCursor move) {
        int c;
        if (move == RBTreeReader.MoveCursor.TO_DOCUMENT_ROOT) {
            this.moveToDocumentRoot();
        }
        RevisionRootPage root = this.pageTrx.getActualRevisionRootPage();
        if (this.rbTreeReader.getCurrentNodeAsRBNodeKey() == null && ((StructNode)this.getNode()).getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            long nodeKey = this.getNewNodeKey(root);
            RBNodeKey<K> treeRoot = this.pageTrx.createRecord(new RBNodeKey<K>(key, nodeKey + 1L, new NodeDelegate(nodeKey, Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), null, 0, 0, (SirixDeweyID)null)), this.rbTreeReader.indexType, this.rbTreeReader.index);
            this.pageTrx.createRecord(new RBNodeValue<V>(value, new NodeDelegate(nodeKey + 1L, nodeKey, null, 0, 0, (SirixDeweyID)null)), this.rbTreeReader.indexType, this.rbTreeReader.index);
            StructNode document = (StructNode)this.pageTrx.prepareRecordForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            document.setFirstChildKey(treeRoot.getNodeKey());
            document.incrementChildCount();
            document.incrementDescendantCount();
            return value;
        }
        if (move == RBTreeReader.MoveCursor.TO_DOCUMENT_ROOT || this.rbTreeReader.getCurrentNodeAsRBNodeKey() == null) {
            this.moveToDocumentRoot();
            this.moveToFirstChild();
        }
        RBNodeKey node = this.rbTreeReader.getCurrentNodeAsRBNodeKey();
        while (true) {
            boolean moved;
            if ((c = key.compareTo(node.getKey())) == 0) {
                this.rbTreeReader.moveTo(node.getValueNodeKey());
                RBNodeValue rbNodeValue = this.rbTreeReader.getCurrentNodeAsRBNodeValue();
                assert (rbNodeValue != null);
                References rbValueNodeValue = (References)rbNodeValue.getValue();
                rbNodeValue = (RBNodeValue)this.pageTrx.prepareRecordForModification(node.getValueNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
                rbNodeValue.setValue(value);
                this.rbTreeReader.setCurrentNode(node);
                return (V)((References)rbNodeValue.getValue());
            }
            boolean bl = moved = c < 0 ? this.moveToFirstChild() : this.moveToLastChild();
            if (!moved) break;
            node = this.rbTreeReader.getCurrentNodeAsRBNodeKey();
        }
        long nodeKey = this.getNewNodeKey(root);
        long valueNodeKey = nodeKey + 1L;
        RBNodeKey<K> child = this.pageTrx.createRecord(new RBNodeKey<K>(key, nodeKey + 1L, new NodeDelegate(nodeKey, node.getNodeKey(), null, 0, 0, (SirixDeweyID)null)), this.rbTreeReader.indexType, this.rbTreeReader.index);
        this.pageTrx.createRecord(new RBNodeValue<V>(value, new NodeDelegate(valueNodeKey, nodeKey, null, 0, 0, (SirixDeweyID)null)), this.rbTreeReader.indexType, this.rbTreeReader.index);
        node = (RBNodeKey)this.pageTrx.prepareRecordForModification(node.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        if (c < 0) {
            node.setLeftChildKey(child.getNodeKey());
        } else {
            node.setRightChildKey(child.getNodeKey());
        }
        this.adjust(child);
        StructNode document = (StructNode)this.pageTrx.prepareRecordForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        document.incrementDescendantCount();
        return value;
    }

    private long getNewNodeKey(RevisionRootPage root) {
        return switch (this.rbTreeReader.indexType) {
            case IndexType.PATH -> this.pageTrx.getPathPage(root).getMaxNodeKey(this.rbTreeReader.index) + 1L;
            case IndexType.CAS -> this.pageTrx.getCASPage(root).getMaxNodeKey(this.rbTreeReader.index) + 1L;
            case IndexType.NAME -> this.pageTrx.getNamePage(root).getMaxNodeKey(this.rbTreeReader.index) + 1L;
            case IndexType.PATH_SUMMARY -> this.pageTrx.getPathSummaryPage(root).getMaxNodeKey(this.rbTreeReader.index) + 1L;
            default -> throw new IllegalStateException();
        };
    }

    public boolean remove(K key, @NonNegative long nodeKey) {
        References value;
        Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"nodeKey must be >= 0!");
        Optional<V> searchedValue = this.rbTreeReader.get((Comparable)Objects.requireNonNull(key), SearchMode.EQUAL);
        boolean removed = false;
        if (searchedValue.isPresent() && (removed = (value = (References)searchedValue.get()).removeNodeKey(nodeKey))) {
            RBNodeValue node = (RBNodeValue)this.pageTrx.prepareRecordForModification(this.rbTreeReader.getCurrentNodeAsRBNodeKey().getValueNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            ((References)node.getValue()).removeNodeKey(nodeKey);
        }
        return removed;
    }

    private void adjust(RBNodeKey<K> node) {
        this.setChanged(node, true);
        while (node != null && node.getParentKey() != Fixed.DOCUMENT_NODE_KEY.getStandardProperty() && this.parent(node) != null && this.parent(node).isChanged()) {
            RBNodeKey<K> y;
            if (this.parent(node).equals(this.left(this.parent(this.parent(node))))) {
                y = this.right(this.parent(this.parent(node)));
                if (y != null && y.isChanged()) {
                    this.setChanged(this.parent(node), false);
                    y.setChanged(false);
                    this.setChanged(this.parent(this.parent(node)), true);
                    node = this.parent(this.parent(node));
                    continue;
                }
                if (node.equals(this.right(this.parent(node)))) {
                    node = this.parent(node);
                    this.rotateLeft(node);
                }
                this.setChanged(this.parent(node), false);
                this.setChanged(this.parent(this.parent(node)), true);
                if (this.parent(this.parent(node)) == null) continue;
                this.rotateRight(this.parent(this.parent(node)));
                continue;
            }
            if (this.parent(node).equals(this.right(this.parent(this.parent(node))))) {
                y = this.left(this.parent(this.parent(node)));
                if (y != null && y.isChanged()) {
                    this.setChanged(this.parent(node), false);
                    this.setChanged(y, false);
                    this.setChanged(this.parent(this.parent(node)), true);
                    node = this.parent(this.parent(node));
                    continue;
                }
                if (node.equals(this.left(this.parent(node)))) {
                    node = this.parent(node);
                    this.rotateRight(node);
                }
                this.setChanged(this.parent(node), false);
                this.setChanged(this.parent(this.parent(node)), true);
                if (this.parent(this.parent(node)) == null) continue;
                this.rotateLeft(this.parent(this.parent(node)));
                continue;
            }
            node = null;
        }
        long nodeKey = this.getNodeKey();
        this.moveToDocumentRoot();
        if (((StructNode)this.getNode()).hasFirstChild()) {
            this.moveToFirstChild();
            this.setChanged(this.rbTreeReader.getCurrentNodeAsRBNodeKey(), false);
        }
        this.moveTo(nodeKey);
    }

    private void setChanged(RBNodeKey<K> nodeToChange, boolean changed) {
        RBNodeKey node = (RBNodeKey)this.pageTrx.prepareRecordForModification(nodeToChange.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        node.setChanged(changed);
    }

    private RBNodeKey<K> left(@Nullable RBNodeKey<K> node) {
        if (node == null || node.getLeftChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        RBNodeKey<K> leftChild = node.getLeftChild();
        if (leftChild != null) {
            this.rbTreeReader.setCurrentNode(leftChild);
            assert (node.getLeftChildKey() == leftChild.getNodeKey());
            return leftChild;
        }
        return this.moveTo(node.getLeftChildKey()) ? this.rbTreeReader.getCurrentNodeAsRBNodeKey() : null;
    }

    private RBNodeKey<K> right(@Nullable RBNodeKey<K> node) {
        if (node == null || node.getRightChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        RBNodeKey<K> rightChild = node.getRightChild();
        if (rightChild != null) {
            this.rbTreeReader.setCurrentNode(rightChild);
            assert (node.getRightChildKey() == rightChild.getNodeKey());
            return rightChild;
        }
        return this.moveTo(node.getRightChildKey()) ? this.rbTreeReader.getCurrentNodeAsRBNodeKey() : null;
    }

    private RBNodeKey<K> parent(@Nullable RBNodeKey<K> node) {
        if (node == null || node.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return null;
        }
        RBNodeKey<K> parent = node.getParent();
        if (parent != null) {
            this.rbTreeReader.setCurrentNode(parent);
            assert (node.getParentKey() == parent.getNodeKey());
            return parent;
        }
        return this.moveTo(node.getParentKey()) ? this.rbTreeReader.getCurrentNodeAsRBNodeKey() : null;
    }

    private void rotateLeft(RBNodeKey<K> node) {
        this.moveTo(node.getNodeKey());
        this.moveToLastChild();
        RBNodeKey right = (RBNodeKey)this.getNode();
        node = (RBNodeKey)this.pageTrx.prepareRecordForModification(node.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        assert (right != null);
        node.setRightChildKey(right.getLeftChildKey());
        node.setRightChild(right.getLeftChild());
        if (right.hasLeftChild()) {
            RBNodeKey rightLeftChild = (RBNodeKey)this.pageTrx.prepareRecordForModification(right.getLeftChildKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            rightLeftChild.setParentKey(node.getNodeKey());
            rightLeftChild.setParent(node);
        }
        right = (RBNodeKey)this.pageTrx.prepareRecordForModification(right.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        right.setParentKey(node.getParentKey());
        right.setParent(node.getParent());
        if (node.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            parent = (StructNode)this.pageTrx.prepareRecordForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            parent.setFirstChildKey(right.getNodeKey());
        } else if (this.moveTo(node.getParentKey()) && this.rbTreeReader.getCurrentNodeAsRBNodeKey().getLeftChildKey() == node.getNodeKey()) {
            parent = (RBNodeKey)this.pageTrx.prepareRecordForModification(this.rbTreeReader.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            ((RBNodeKey)parent).setLeftChildKey(right.getNodeKey());
            ((RBNodeKey)parent).setLeftChild(right);
        } else {
            parent = (RBNodeKey)this.pageTrx.prepareRecordForModification(this.rbTreeReader.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            ((RBNodeKey)parent).setRightChildKey(right.getNodeKey());
            ((RBNodeKey)parent).setRightChild(right);
        }
        right = (RBNodeKey)this.pageTrx.prepareRecordForModification(right.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        right.setLeftChildKey(node.getNodeKey());
        right.setLeftChild(node);
        node = (RBNodeKey)this.pageTrx.prepareRecordForModification(node.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        node.setParentKey(right.getNodeKey());
        node.setParent(right);
    }

    private void rotateRight(RBNodeKey<K> node) {
        this.moveTo(node.getNodeKey());
        this.moveToFirstChild();
        RBNodeKey leftChild = (RBNodeKey)this.getNode();
        node = (RBNodeKey)this.pageTrx.prepareRecordForModification(node.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        assert (leftChild != null);
        node.setLeftChildKey(leftChild.getRightChildKey());
        node.setLeftChild(leftChild.getRightChild());
        if (leftChild.hasRightChild()) {
            RBNodeKey leftRightChild = (RBNodeKey)this.pageTrx.prepareRecordForModification(leftChild.getRightChildKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            leftRightChild.setParentKey(node.getNodeKey());
            leftRightChild.setParent(node);
        }
        leftChild = (RBNodeKey)this.pageTrx.prepareRecordForModification(leftChild.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        leftChild.setParentKey(node.getParentKey());
        leftChild.setParent(node.getParent());
        if (node.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            parent = (StructNode)this.pageTrx.prepareRecordForModification(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            parent.setFirstChildKey(leftChild.getNodeKey());
        } else if (this.moveTo(node.getParentKey()) && this.rbTreeReader.getCurrentNodeAsRBNodeKey().getRightChildKey() == node.getNodeKey()) {
            parent = (RBNodeKey)this.pageTrx.prepareRecordForModification(this.rbTreeReader.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            ((RBNodeKey)parent).setRightChildKey(leftChild.getNodeKey());
            ((RBNodeKey)parent).setRightChild(leftChild);
        } else {
            parent = (RBNodeKey)this.pageTrx.prepareRecordForModification(this.rbTreeReader.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
            ((RBNodeKey)parent).setLeftChildKey(leftChild.getNodeKey());
            ((RBNodeKey)parent).setLeftChild(leftChild);
        }
        leftChild = (RBNodeKey)this.pageTrx.prepareRecordForModification(leftChild.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        leftChild.setRightChildKey(node.getNodeKey());
        leftChild.setRightChild(node);
        node = (RBNodeKey)this.pageTrx.prepareRecordForModification(node.getNodeKey(), this.rbTreeReader.indexType, this.rbTreeReader.index);
        node.setParentKey(leftChild.getNodeKey());
        node.setParent(leftChild);
    }

    @Override
    public void close() {
        this.rbTreeReader.close();
    }

    @Override
    protected NodeCursor delegate() {
        return this.rbTreeReader;
    }

    public Optional<V> get(K key, SearchMode mode) {
        return this.rbTreeReader.get((Comparable)Objects.requireNonNull(key), Objects.requireNonNull(mode));
    }

    public RBTreeReader<K, V> getReader() {
        return this.rbTreeReader;
    }
}

