/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.index.redblacktree.keyvalue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.index.redblacktree.interfaces.References;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.roaringbitmap.longlong.PeekableLongIterator;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public final class NodeReferences
implements References {
    private final Roaring64Bitmap nodeKeys;

    public NodeReferences() {
        this.nodeKeys = new Roaring64Bitmap();
    }

    public NodeReferences(Roaring64Bitmap nodeKeys) {
        assert (nodeKeys != null);
        this.nodeKeys = nodeKeys.clone();
    }

    @Override
    public boolean isPresent(@NonNegative long nodeKey) {
        return this.nodeKeys.contains(nodeKey);
    }

    @Override
    public Roaring64Bitmap getNodeKeys() {
        return this.nodeKeys;
    }

    @Override
    public NodeReferences addNodeKey(@NonNegative long nodeKey) {
        this.nodeKeys.add(new long[]{nodeKey});
        return this;
    }

    @Override
    public boolean removeNodeKey(@NonNegative long nodeKey) {
        boolean containsNodeKey = this.nodeKeys.contains(nodeKey);
        this.nodeKeys.removeLong(nodeKey);
        return containsNodeKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeKeys});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NodeReferences) {
            NodeReferences refs = (NodeReferences)obj;
            return this.nodeKeys.equals((Object)refs.nodeKeys);
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        PeekableLongIterator iterator = this.nodeKeys.getLongIterator();
        while (iterator.hasNext()) {
            long nodeKey = iterator.next();
            helper.add("referenced node key", nodeKey);
        }
        return helper.toString();
    }

    @Override
    public boolean hasNodeKeys() {
        return !this.nodeKeys.isEmpty();
    }

    @Override
    public boolean contains(@NonNegative long nodeKey) {
        return this.nodeKeys.contains(nodeKey);
    }
}

