/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;

public final class BytesUtils {
    private BytesUtils() {
        throw new AssertionError();
    }

    public static void doWrite(Bytes<?> bytes, ByteBuffer toWrite) {
        bytes.clear();
        bytes.write(bytes.writePosition(), toWrite, toWrite.position(), toWrite.limit());
    }

    public static void doWrite(Bytes<?> bytes, byte[] toWrite) {
        bytes.clear();
        bytes.write(toWrite);
    }

    public static ByteBuffer doRead(Bytes bytes) {
        assert (bytes.underlyingObject() instanceof ByteBuffer);
        ByteBuffer byteBuffer = (ByteBuffer)bytes.underlyingObject();
        return byteBuffer;
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuilder buffer = new StringBuilder("byte[");
        buffer.append(bytes.length);
        buffer.append("]: [");
        for (byte aByte : bytes) {
            buffer.append(aByte);
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String dumpBytes(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int length = byteBuffer.limit() - byteBuffer.position();
        byte[] dst = new byte[length];
        byteBuffer.get(dst);
        byteBuffer.reset();
        return BytesUtils.dumpBytes(dst);
    }
}

