/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import com.github.benmanes.caffeine.cache.AsyncCache;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PageReference;
import io.sirix.page.UberPage;
import java.util.ArrayList;
import java.util.HashMap;

public interface IOStorage {
    public static final String FILENAME = "sirix.data";
    public static final String REVISIONS_FILENAME = "sirix.revisions";
    public static final int FIRST_BEACON = 1024;
    public static final int OTHER_BEACON = 4;

    public Writer createWriter();

    public Reader createReader();

    public void close();

    public boolean exists();

    default public void loadRevisionFileDataIntoMemory(AsyncCache<Integer, RevisionFileData> cache) {
        if (!cache.asMap().isEmpty()) {
            return;
        }
        if (this.exists()) {
            Reader reader = this.createReader();
            PageReference firstRef = reader.readUberPageReference();
            UberPage uberPage = (UberPage)firstRef.getPage();
            int revisionNumber = uberPage.getRevisionNumber();
            ArrayList<Integer> revisionNumbers = new ArrayList<Integer>(revisionNumber);
            for (int i = 1; i <= revisionNumber; ++i) {
                revisionNumbers.add(i);
            }
            cache.getAll(revisionNumbers, keys -> {
                HashMap result = new HashMap();
                keys.forEach(key -> result.put(key, reader.getRevisionFileData((int)key)));
                reader.close();
                return result;
            });
        }
    }

    public ByteHandler getByteHandler();
}

