/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.io.RevisionFileData;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.interfaces.Page;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Reader
extends AutoCloseable {
    public static final HashFunction hashFunction = Hashing.sha256();
    public static final ExecutorService POOL = Executors.newVirtualThreadPerTaskExecutor();

    public PageReference readUberPageReference();

    default public CompletableFuture<? extends Page> readAsync(PageReference key, @Nullable PageReadOnlyTrx pageReadTrx) {
        return CompletableFuture.supplyAsync(() -> this.read(key, pageReadTrx), POOL);
    }

    public Page read(PageReference var1, @Nullable PageReadOnlyTrx var2);

    @Override
    public void close();

    public RevisionRootPage readRevisionRootPage(int var1, PageReadOnlyTrx var2);

    public Instant readRevisionRootPageCommitTimestamp(int var1);

    public RevisionFileData getRevisionFileData(int var1);
}

