/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.sirix.access.ResourceConfiguration;
import io.sirix.io.IOStorage;
import io.sirix.io.RevisionFileData;
import io.sirix.io.file.FileStorage;
import io.sirix.io.filechannel.FileChannelStorage;
import io.sirix.io.iouring.IOUringStorage;
import io.sirix.io.memorymapped.MMStorage;
import io.sirix.io.ram.RAMStorage;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum StorageType {
    IN_MEMORY{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            return new RAMStorage(resourceConf);
        }
    }
    ,
    FILE{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            AsyncCache<Integer, RevisionFileData> cache = StorageType.getIntegerRevisionFileDataAsyncCache(resourceConf);
            FileStorage storage = new FileStorage(resourceConf, cache);
            storage.loadRevisionFileDataIntoMemory(cache);
            return storage;
        }
    }
    ,
    FILE_CHANNEL{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            AsyncCache<Integer, RevisionFileData> cache = StorageType.getIntegerRevisionFileDataAsyncCache(resourceConf);
            FileChannelStorage storage = new FileChannelStorage(resourceConf, cache);
            storage.loadRevisionFileDataIntoMemory(cache);
            return storage;
        }
    }
    ,
    DIRECT_IO{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            AsyncCache<Integer, RevisionFileData> cache = StorageType.getIntegerRevisionFileDataAsyncCache(resourceConf);
            io.sirix.io.directio.FileChannelStorage storage = new io.sirix.io.directio.FileChannelStorage(resourceConf, cache);
            storage.loadRevisionFileDataIntoMemory(cache);
            return storage;
        }
    }
    ,
    MEMORY_MAPPED{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            AsyncCache<Integer, RevisionFileData> cache = StorageType.getIntegerRevisionFileDataAsyncCache(resourceConf);
            MMStorage storage = new MMStorage(resourceConf, cache);
            storage.loadRevisionFileDataIntoMemory(cache);
            return storage;
        }
    }
    ,
    IO_URING{

        @Override
        public IOStorage getInstance(ResourceConfiguration resourceConf) {
            AsyncCache<Integer, RevisionFileData> cache = StorageType.getIntegerRevisionFileDataAsyncCache(resourceConf);
            IOUringStorage storage = new IOUringStorage(resourceConf, cache);
            storage.loadRevisionFileDataIntoMemory(cache);
            return storage;
        }
    };

    public static final ConcurrentMap<Path, AsyncCache<Integer, RevisionFileData>> CACHE_REPOSITORY;

    public abstract IOStorage getInstance(ResourceConfiguration var1);

    public static IOStorage getStorage(ResourceConfiguration resourceConf) {
        return resourceConf.storageType.getInstance(resourceConf);
    }

    private static AsyncCache<Integer, RevisionFileData> getIntegerRevisionFileDataAsyncCache(ResourceConfiguration resourceConf) {
        Path resourcePath = resourceConf.resourcePath.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve("sirix.data");
        return CACHE_REPOSITORY.computeIfAbsent(resourcePath, path -> Caffeine.newBuilder().buildAsync());
    }

    static {
        CACHE_REPOSITORY = new ConcurrentHashMap<Path, AsyncCache<Integer, RevisionFileData>>();
    }
}

