/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.directio;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.hash.HashFunction;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractReader;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.time.Instant;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FileChannelReader
extends AbstractReader {
    final HashFunction hashFunction = Reader.hashFunction;
    private final FileChannel dataFileChannel;
    private final FileChannel revisionsOffsetFileChannel;
    private final Cache<Integer, RevisionFileData> cache;

    public FileChannelReader(FileChannel dataFileChannel, FileChannel revisionsOffsetFileChannel, ByteHandler handler, SerializationType type, PagePersister pagePersistenter, Cache<Integer, RevisionFileData> cache) {
        super(handler, pagePersistenter, type);
        this.dataFileChannel = dataFileChannel;
        this.revisionsOffsetFileChannel = revisionsOffsetFileChannel;
        this.cache = cache;
    }

    @Override
    public Page read(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            long position = reference.getKey();
            this.dataFileChannel.read(buffer, position);
            buffer.flip();
            int dataLength = buffer.getInt();
            buffer = ByteBuffer.allocate(dataLength).order(ByteOrder.nativeOrder());
            this.dataFileChannel.read(buffer, position + 4L);
            buffer.flip();
            byte[] page = buffer.array();
            return this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public PageReference readUberPageReference() {
        PageReference uberPageReference = new PageReference();
        uberPageReference.setKey(0L);
        UberPage page = (UberPage)this.read(uberPageReference, null);
        uberPageReference.setPage(page);
        return uberPageReference;
    }

    @Override
    public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
        try {
            long dataFileOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).offset();
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            this.dataFileChannel.read(buffer, dataFileOffset);
            buffer.flip();
            int dataLength = buffer.getInt();
            buffer = ByteBuffer.allocateDirect(dataLength).order(ByteOrder.nativeOrder());
            this.dataFileChannel.read(buffer, dataFileOffset + 4L);
            buffer.flip();
            byte[] page = new byte[dataLength];
            buffer.get(page);
            return (RevisionRootPage)this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Instant readRevisionRootPageCommitTimestamp(int revision) {
        return ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).timestamp();
    }

    @Override
    public RevisionFileData getRevisionFileData(int revision) {
        try {
            int fileOffset = revision * 8 * 2 + 1024;
            ByteBuffer buffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
            this.revisionsOffsetFileChannel.read(buffer, fileOffset);
            buffer.position(8);
            this.revisionsOffsetFileChannel.read(buffer, fileOffset + 8);
            buffer.flip();
            long offset = buffer.getLong();
            buffer.position(8);
            long timestamp = buffer.getLong();
            return new RevisionFileData(offset, Instant.ofEpochMilli(timestamp));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

