/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.file;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FileReader
implements Reader {
    final ByteHandler byteHandler;
    final HashFunction hashFunction = Hashing.sha256();
    private final RandomAccessFile dataFile;
    private final RandomAccessFile revisionsOffsetFile;
    private final SerializationType serializationType;
    private final PagePersister pagePersiter;
    private final Cache<Integer, RevisionFileData> cache;

    public FileReader(RandomAccessFile dataFile, RandomAccessFile revisionsOffsetFile, ByteHandler byteHandler, SerializationType serializationType, PagePersister pagePersister, Cache<Integer, RevisionFileData> cache) {
        this.dataFile = Objects.requireNonNull(dataFile);
        this.revisionsOffsetFile = serializationType == SerializationType.DATA ? Objects.requireNonNull(revisionsOffsetFile) : null;
        this.byteHandler = Objects.requireNonNull(byteHandler);
        this.serializationType = Objects.requireNonNull(serializationType);
        this.pagePersiter = Objects.requireNonNull(pagePersister);
        this.cache = cache;
    }

    @Override
    public Page read(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            this.dataFile.seek(reference.getKey());
            int dataLength = this.dataFile.readInt();
            byte[] page = new byte[dataLength];
            this.dataFile.read(page);
            return this.getPage(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private @NonNull Page getPage(PageReadOnlyTrx pageReadTrx, byte[] page) throws IOException {
        InputStream inputStream = this.byteHandler.deserialize(new ByteArrayInputStream(page));
        Bytes input = Bytes.wrapForRead((byte[])inputStream.readAllBytes());
        Page deserializedPage = this.pagePersiter.deserializePage(pageReadTrx, (BytesIn<?>)input, this.serializationType);
        input.clear();
        return deserializedPage;
    }

    @Override
    public PageReference readUberPageReference() {
        PageReference uberPageReference = new PageReference();
        try {
            this.dataFile.seek(0L);
            uberPageReference.setKey(0L);
            UberPage page = (UberPage)this.read(uberPageReference, null);
            uberPageReference.setPage(page);
            return uberPageReference;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
        try {
            long offsetIntoDataFile = this.cache != null ? ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).offset() : this.getRevisionFileData(revision).offset();
            this.dataFile.seek(offsetIntoDataFile);
            int dataLength = this.dataFile.readInt();
            byte[] page = new byte[dataLength];
            this.dataFile.read(page);
            Bytes input = Bytes.wrapForRead((ByteBuffer)ByteBuffer.wrap(page));
            return (RevisionRootPage)this.pagePersiter.deserializePage(pageReadTrx, (BytesIn<?>)input, this.serializationType);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Instant readRevisionRootPageCommitTimestamp(int revision) {
        return ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).timestamp();
    }

    @Override
    public RevisionFileData getRevisionFileData(int revision) {
        try {
            int fileOffset = revision * 8 * 2 + 1024;
            this.revisionsOffsetFile.seek(fileOffset);
            long offset = this.revisionsOffsetFile.readLong();
            this.revisionsOffsetFile.seek(fileOffset + 8);
            Instant timestamp = Instant.ofEpochMilli(this.revisionsOffsetFile.readLong());
            return new RevisionFileData(offset, timestamp);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.revisionsOffsetFile != null) {
                this.revisionsOffsetFile.close();
            }
            this.dataFile.close();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }
}

