/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.file;

import com.github.benmanes.caffeine.cache.AsyncCache;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractForwardingReader;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.file.FileReader;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileWriter
extends AbstractForwardingReader
implements Writer {
    private final RandomAccessFile dataFile;
    private final FileReader reader;
    private final SerializationType type;
    private final RandomAccessFile revisionsFile;
    private final PagePersister pagePersister;
    private final AsyncCache<Integer, RevisionFileData> cache;
    private boolean isFirstUberPage;
    private final Bytes<ByteBuffer> byteBufferBytes = Bytes.elasticByteBuffer((int)1000);

    public FileWriter(RandomAccessFile dataFile, RandomAccessFile revisionsOffsetFile, SerializationType serializationType, PagePersister pagePersister, AsyncCache<Integer, RevisionFileData> cache, FileReader reader) {
        this.dataFile = Objects.requireNonNull(dataFile);
        this.type = Objects.requireNonNull(serializationType);
        this.revisionsFile = this.type == SerializationType.DATA ? Objects.requireNonNull(revisionsOffsetFile) : null;
        this.pagePersister = Objects.requireNonNull(pagePersister);
        this.cache = cache;
        this.reader = Objects.requireNonNull(reader);
    }

    @Override
    public Writer truncateTo(PageReadOnlyTrx pageReadOnlyTrx, int revision) {
        try {
            long dataFileRevisionRootPageOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision)).get(5L, TimeUnit.SECONDS)).offset();
            this.dataFile.seek(dataFileRevisionRootPageOffset);
            int dataLength = this.dataFile.readInt();
            this.dataFile.getChannel().truncate(dataFileRevisionRootPageOffset + 4L + (long)dataLength);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public FileWriter write(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        try {
            long fileSize = this.dataFile.length();
            long offset = fileSize == 0L ? 1024L : fileSize;
            return this.writePageReference(pageReadOnlyTrx, pageReference, offset);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private @NonNull FileWriter writePageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, long offset) {
        try {
            byte[] serializedPage;
            Page page = pageReference.getPage();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(1000);){
                try (DataOutputStream dataOutput = new DataOutputStream(this.reader.byteHandler.serialize(output));){
                    this.pagePersister.serializePage(pageReadOnlyTrx, (BytesOut<?>)this.byteBufferBytes, page, this.type);
                    byte[] byteArray = this.byteBufferBytes.toByteArray();
                    dataOutput.write(byteArray);
                    dataOutput.flush();
                }
                serializedPage = output.toByteArray();
            }
            this.byteBufferBytes.clear();
            byte[] writtenPage = new byte[serializedPage.length + 4];
            ByteBuffer buffer = ByteBuffer.allocate(writtenPage.length);
            buffer.putInt(serializedPage.length);
            buffer.put(serializedPage);
            buffer.flip();
            buffer.get(writtenPage);
            if (this.type == SerializationType.DATA) {
                if (page instanceof RevisionRootPage) {
                    if (offset % 256L != 0L) {
                        offset += 256L - offset % 256L;
                    }
                } else if (offset % 8L != 0L) {
                    offset += 8L - offset % 8L;
                }
            }
            this.dataFile.seek(offset);
            this.dataFile.write(writtenPage);
            pageReference.setKey(offset);
            if (page instanceof KeyValueLeafPage) {
                KeyValueLeafPage keyValueLeafPage = (KeyValueLeafPage)page;
                pageReference.setHash(keyValueLeafPage.getHashCode());
            } else {
                pageReference.setHash(this.reader.hashFunction.hashBytes(serializedPage).asBytes());
            }
            if (this.type == SerializationType.DATA) {
                if (page instanceof RevisionRootPage) {
                    RevisionRootPage revisionRootPage = (RevisionRootPage)page;
                    if (revisionRootPage.getRevision() == 0) {
                        this.revisionsFile.seek(this.revisionsFile.length() + 1024L);
                    } else {
                        this.revisionsFile.seek(this.revisionsFile.length());
                    }
                    this.revisionsFile.writeLong(offset);
                    this.revisionsFile.writeLong(revisionRootPage.getRevisionTimestamp());
                    if (this.cache != null) {
                        long currOffset = offset;
                        this.cache.put((Object)revisionRootPage.getRevision(), CompletableFuture.supplyAsync(() -> new RevisionFileData(currOffset, Instant.ofEpochMilli(revisionRootPage.getRevisionTimestamp()))));
                    }
                } else if (page instanceof UberPage && this.isFirstUberPage) {
                    this.revisionsFile.seek(0L);
                    this.revisionsFile.write(serializedPage);
                    this.revisionsFile.seek(512L);
                    this.revisionsFile.write(serializedPage);
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            if (this.revisionsFile != null) {
                this.revisionsFile.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Writer writeUberPageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        this.isFirstUberPage = true;
        this.writePageReference(pageReadOnlyTrx, pageReference, 0L);
        this.isFirstUberPage = false;
        this.writePageReference(pageReadOnlyTrx, pageReference, 100L);
        return this;
    }

    @Override
    protected Reader delegate() {
        return this.reader;
    }

    @Override
    public Writer truncate() {
        try {
            this.dataFile.setLength(0L);
            if (this.revisionsFile != null) {
                this.revisionsFile.setLength(0L);
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        return this;
    }
}

