/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.iouring;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.hash.HashFunction;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractReader;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.interfaces.Page;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import one.jasyncfio.AsyncFile;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IOUringReader
extends AbstractReader {
    final HashFunction hashFunction = Reader.hashFunction;
    private final AsyncFile dataFile;
    private final AsyncFile revisionsOffsetFile;
    private final Cache<Integer, RevisionFileData> cache;

    public IOUringReader(AsyncFile dataFile, AsyncFile revisionsOffsetFile, ByteHandler handler, SerializationType type, PagePersister pagePersistenter, Cache<Integer, RevisionFileData> cache) {
        super(handler, pagePersistenter, type);
        this.dataFile = dataFile;
        this.revisionsOffsetFile = revisionsOffsetFile;
        this.cache = cache;
    }

    @Override
    public Page read(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            return POOL.submit(() -> this.readPageFragment(reference, pageReadTrx)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public CompletableFuture<? extends Page> readAsync(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        return CompletableFuture.supplyAsync(() -> this.readPageFragment(reference, pageReadTrx), POOL);
    }

    private @NonNull Page readPageFragment(@NonNull PageReference reference, @Nullable PageReadOnlyTrx pageReadTrx) {
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            long position = reference.getKey();
            this.dataFile.read(buffer, position).join();
            buffer.flip();
            int dataLength = buffer.getInt();
            buffer = ByteBuffer.allocateDirect(dataLength).order(ByteOrder.nativeOrder());
            this.dataFile.read(buffer, position + 4L).join();
            buffer.flip();
            byte[] page = new byte[dataLength];
            buffer.get(page);
            return this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public RevisionRootPage readRevisionRootPage(int revision, PageReadOnlyTrx pageReadTrx) {
        try {
            long dataFileOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).offset();
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            this.dataFile.read(buffer, dataFileOffset).join();
            buffer.flip();
            int dataLength = buffer.getInt();
            buffer = ByteBuffer.allocateDirect(dataLength).order(ByteOrder.nativeOrder());
            this.dataFile.read(buffer, dataFileOffset + 4L).join();
            buffer.flip();
            byte[] page = new byte[dataLength];
            buffer.get(page);
            return (RevisionRootPage)this.deserialize(pageReadTrx, page);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public Instant readRevisionRootPageCommitTimestamp(int revision) {
        return ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision))).timestamp();
    }

    @Override
    public RevisionFileData getRevisionFileData(int revision) {
        long fileOffset = (long)revision * 8L * 2L + 1024L;
        ByteBuffer buffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
        this.revisionsOffsetFile.read(buffer, fileOffset).join();
        buffer.flip();
        long offset = buffer.getLong();
        buffer.position(8);
        long timestamp = buffer.getLong();
        return new RevisionFileData(offset, Instant.ofEpochMilli(timestamp));
    }

    @Override
    public void close() {
    }
}

