/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.iouring;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import io.sirix.access.ResourceConfiguration;
import io.sirix.exception.SirixIOException;
import io.sirix.io.IOStorage;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.io.iouring.IOUringReader;
import io.sirix.io.iouring.IOUringWriter;
import io.sirix.page.PagePersister;
import io.sirix.page.SerializationType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import one.jasyncfio.AsyncFile;
import one.jasyncfio.EventExecutor;
import one.jasyncfio.OpenOption;

public final class IOUringStorage
implements IOStorage {
    private final Path file;
    private final ByteHandlerPipeline byteHandlerPipeline;
    final Semaphore semaphore = new Semaphore(1);
    private final AsyncCache<Integer, RevisionFileData> cache;
    private static final EventExecutor eventExecutor = EventExecutor.builder().entries(1024).sleepTimeout(10L).build();
    private AsyncFile dataFile;
    private AsyncFile revisionsOffsetFile;

    public IOUringStorage(ResourceConfiguration resourceConfig, AsyncCache<Integer, RevisionFileData> cache) {
        assert (resourceConfig != null) : "resourceConfig must not be null!";
        this.file = resourceConfig.resourcePath;
        this.byteHandlerPipeline = resourceConfig.byteHandlePipeline;
        this.cache = cache;
    }

    @Override
    public Reader createReader() {
        try {
            boolean sempahoreAcquired = this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
            if (!sempahoreAcquired) {
                throw new IllegalStateException("Couldn't acquire semaphore.");
            }
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            this.createRevisionsOffsetFileIfNotExists(revisionsOffsetFilePath);
            this.createRevisionsOffsetFileIfNotInitialized(revisionsOffsetFilePath);
            this.createDataFileIfNotInitialized(dataFilePath);
            IOUringReader iOUringReader = new IOUringReader(this.dataFile, this.revisionsOffsetFile, new ByteHandlerPipeline(this.byteHandlerPipeline), SerializationType.DATA, new PagePersister(), (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            return iOUringReader;
        }
        catch (IOException | InterruptedException e) {
            throw new SirixIOException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private void createDataFileIfNotInitialized(Path dataFilePath) {
        CompletableFuture asyncFileCompletableFuture = AsyncFile.open((Path)dataFilePath, (EventExecutor)eventExecutor, (OpenOption[])new OpenOption[]{OpenOption.READ_WRITE, OpenOption.CREATE});
        this.dataFile = (AsyncFile)asyncFileCompletableFuture.join();
    }

    private void createRevisionsOffsetFileIfNotInitialized(Path revisionsOffsetFilePath) {
        CompletableFuture asyncFileCompletableFuture = AsyncFile.open((Path)revisionsOffsetFilePath, (EventExecutor)eventExecutor, (OpenOption[])new OpenOption[]{OpenOption.READ_WRITE, OpenOption.CREATE});
        this.revisionsOffsetFile = (AsyncFile)asyncFileCompletableFuture.join();
    }

    private Path createDirectoriesAndFile() throws IOException {
        Path concreteStorage = this.getDataFilePath();
        if (!Files.exists(concreteStorage, new LinkOption[0])) {
            Files.createDirectories(concreteStorage.getParent(), new FileAttribute[0]);
            Files.createFile(concreteStorage, new FileAttribute[0]);
        }
        return concreteStorage;
    }

    @Override
    public Writer createWriter() {
        try {
            boolean sempahoreAcquired = this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
            if (!sempahoreAcquired) {
                throw new IllegalStateException("Couldn't acquire semaphore.");
            }
            Path dataFilePath = this.createDirectoriesAndFile();
            Path revisionsOffsetFilePath = this.getRevisionFilePath();
            this.createRevisionsOffsetFileIfNotExists(revisionsOffsetFilePath);
            this.createRevisionsOffsetFileIfNotInitialized(revisionsOffsetFilePath);
            this.createDataFileIfNotInitialized(dataFilePath);
            ByteHandlerPipeline byteHandlePipeline = new ByteHandlerPipeline(this.byteHandlerPipeline);
            SerializationType serializationType = SerializationType.DATA;
            PagePersister pagePersister = new PagePersister();
            IOUringReader reader = new IOUringReader(this.dataFile, this.revisionsOffsetFile, byteHandlePipeline, serializationType, pagePersister, (Cache<Integer, RevisionFileData>)this.cache.synchronous());
            IOUringWriter iOUringWriter = new IOUringWriter(this.dataFile, this.revisionsOffsetFile, dataFilePath, revisionsOffsetFilePath, serializationType, pagePersister, this.cache, reader);
            return iOUringWriter;
        }
        catch (IOException | InterruptedException e) {
            throw new SirixIOException(e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private synchronized void createRevisionsOffsetFileIfNotExists(Path revisionsOffsetFilePath) throws IOException {
        if (!Files.exists(revisionsOffsetFilePath, new LinkOption[0])) {
            Files.createFile(revisionsOffsetFilePath, new FileAttribute[0]);
        }
    }

    @Override
    public void close() {
        try {
            if (this.revisionsOffsetFile != null) {
                this.revisionsOffsetFile.close().join();
            }
            this.dataFile.close().join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Path getDataFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve("sirix.data");
    }

    private Path getRevisionFilePath() {
        return this.file.resolve(ResourceConfiguration.ResourcePaths.DATA.getPath()).resolve("sirix.revisions");
    }

    @Override
    public boolean exists() {
        Path storage = this.getDataFilePath();
        try {
            return Files.exists(storage, new LinkOption[0]) && Files.size(storage) > 0L;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteHandler getByteHandler() {
        return this.byteHandlerPipeline;
    }
}

