/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.io.iouring;

import com.github.benmanes.caffeine.cache.AsyncCache;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.exception.SirixIOException;
import io.sirix.io.AbstractForwardingReader;
import io.sirix.io.Reader;
import io.sirix.io.RevisionFileData;
import io.sirix.io.Writer;
import io.sirix.io.iouring.IOUringReader;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PagePersister;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.Page;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import one.jasyncfio.AsyncFile;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class IOUringWriter
extends AbstractForwardingReader
implements Writer {
    private final AsyncFile dataFile;
    private final IOUringReader reader;
    private final SerializationType serializationType;
    private final AsyncFile revisionsFile;
    private final PagePersister pagePersister;
    private final AsyncCache<Integer, RevisionFileData> cache;
    private final Path dataFilePath;
    private final Path revisionsOffsetFilePath;
    private boolean isFirstUberPage;
    private final Bytes<ByteBuffer> byteBufferBytes = Bytes.elasticByteBuffer((int)1000);

    public IOUringWriter(AsyncFile dataFile, AsyncFile revisionsOffsetFile, Path dataFilePath, Path revisionsOffsetFilePath, SerializationType serializationType, PagePersister pagePersister, AsyncCache<Integer, RevisionFileData> cache, IOUringReader reader) {
        this.dataFile = dataFile;
        this.revisionsFile = revisionsOffsetFile;
        this.dataFilePath = dataFilePath;
        this.revisionsOffsetFilePath = revisionsOffsetFilePath;
        this.serializationType = Objects.requireNonNull(serializationType);
        this.pagePersister = Objects.requireNonNull(pagePersister);
        this.cache = Objects.requireNonNull(cache);
        this.reader = Objects.requireNonNull(reader);
    }

    @Override
    public Writer truncateTo(PageReadOnlyTrx pageReadOnlyTrx, int revision) {
        try {
            long dataFileRevisionRootPageOffset = ((RevisionFileData)this.cache.get((Object)revision, unused -> this.getRevisionFileData(revision)).get(5L, TimeUnit.SECONDS)).offset();
            ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder());
            this.dataFile.read(buffer, dataFileRevisionRootPageOffset).join();
            buffer.position(0);
            int dataLength = buffer.getInt();
            new RandomAccessFile(this.dataFilePath.toFile(), "rw").getChannel().truncate(dataFileRevisionRootPageOffset + 4L + (long)dataLength);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public IOUringWriter write(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        try {
            long offset = this.getOffset(bufferedBytes);
            return this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, offset);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private long getOffset(Bytes<ByteBuffer> bufferedBytes) throws IOException {
        long offset;
        long fileSize = (Long)this.dataFile.size().join();
        if (fileSize == 0L) {
            offset = 1024L;
            offset += 8L - (offset & 7L);
            offset += bufferedBytes.writePosition();
        } else {
            offset = fileSize + bufferedBytes.writePosition();
        }
        return offset;
    }

    private @NonNull IOUringWriter writePageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes, long offset) {
        try {
            POOL.submit(() -> this.writePage(pageReadOnlyTrx, pageReference, bufferedBytes, offset)).get();
            return this;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SirixIOException(e);
        }
    }

    private @NonNull IOUringWriter writePage(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes, long offset) {
        try {
            byte[] serializedPage;
            Page page = pageReference.getPage();
            assert (page != null);
            this.pagePersister.serializePage(pageReadOnlyTrx, (BytesOut<?>)this.byteBufferBytes, page, this.serializationType);
            byte[] byteArray = this.byteBufferBytes.toByteArray();
            if (page instanceof KeyValueLeafPage) {
                serializedPage = byteArray;
            } else {
                try (ByteArrayOutputStream output = new ByteArrayOutputStream(byteArray.length);){
                    try (DataOutputStream dataOutput = new DataOutputStream(this.reader.getByteHandler().serialize(output));){
                        dataOutput.write(byteArray);
                        dataOutput.flush();
                    }
                    serializedPage = output.toByteArray();
                }
            }
            this.byteBufferBytes.clear();
            int offsetToAdd = 0;
            if (this.serializationType == SerializationType.DATA) {
                if (page instanceof UberPage) {
                    offsetToAdd = 512 - (serializedPage.length + 4) % 512;
                } else if (page instanceof RevisionRootPage && offset % 256L != 0L) {
                    offsetToAdd = (int)(256L - (offset & 0xFFL));
                    offset += (long)offsetToAdd;
                } else if (offset % 8L != 0L) {
                    offsetToAdd = (int)(8L - (offset & 7L));
                    offset += (long)offsetToAdd;
                }
            }
            ByteBuffer pageBuffer = ByteBuffer.allocateDirect(serializedPage.length + 4 + offsetToAdd).order(ByteOrder.nativeOrder());
            pageBuffer.putInt(serializedPage.length);
            pageBuffer.put(serializedPage);
            if (page instanceof UberPage && offsetToAdd > 0) {
                byte[] bytesToAdd = new byte[offsetToAdd];
                pageBuffer.put(bytesToAdd);
            }
            pageBuffer.flip();
            this.dataFile.write(pageBuffer, offset).join();
            pageReference.setKey(offset);
            if (page instanceof KeyValueLeafPage) {
                KeyValueLeafPage keyValueLeafPage = (KeyValueLeafPage)page;
                pageReference.setHash(keyValueLeafPage.getHashCode());
            } else {
                pageReference.setHash(this.reader.hashFunction.hashBytes(serializedPage).asBytes());
            }
            if (this.serializationType == SerializationType.DATA) {
                if (page instanceof RevisionRootPage) {
                    RevisionRootPage revisionRootPage = (RevisionRootPage)page;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
                    buffer.putLong(offset);
                    buffer.position(8);
                    buffer.putLong(revisionRootPage.getRevisionTimestamp());
                    buffer.position(0);
                    long revisionsFileOffset = revisionRootPage.getRevision() == 0 ? (Long)this.revisionsFile.size().join() + 1024L : (Long)this.revisionsFile.size().join();
                    this.revisionsFile.write(buffer, revisionsFileOffset).join();
                    long currOffset = offset;
                    this.cache.put((Object)revisionRootPage.getRevision(), CompletableFuture.supplyAsync(() -> new RevisionFileData(currOffset, Instant.ofEpochMilli(revisionRootPage.getRevisionTimestamp()))));
                } else if (page instanceof UberPage && this.isFirstUberPage) {
                    ByteBuffer firstUberPageBuffer = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder());
                    firstUberPageBuffer.put(serializedPage);
                    firstUberPageBuffer.position(0);
                    this.revisionsFile.write(firstUberPageBuffer, 0L).join();
                    ByteBuffer secondUberPageBuffer = ByteBuffer.allocateDirect(512).order(ByteOrder.nativeOrder());
                    secondUberPageBuffer.put(serializedPage);
                    secondUberPageBuffer.position(0);
                    this.revisionsFile.write(secondUberPageBuffer, 512L).join();
                    this.revisionsFile.dataSync().join();
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    @Override
    public void close() {
        if (this.dataFile != null) {
            this.dataFile.dataSync().join();
        }
        if (this.revisionsFile != null) {
            this.revisionsFile.dataSync().join();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public Writer writeUberPageReference(PageReadOnlyTrx pageReadOnlyTrx, PageReference pageReference, Bytes<ByteBuffer> bufferedBytes) {
        this.isFirstUberPage = true;
        this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, 0L);
        this.isFirstUberPage = false;
        this.writePageReference(pageReadOnlyTrx, pageReference, bufferedBytes, 512L);
        this.dataFile.dataSync().join();
        return this;
    }

    private void flushBuffer(PageTrx pageTrx, ByteBuffer buffer) throws IOException {
        long offset;
        long fileSize = (Long)this.dataFile.size().join();
        if (fileSize == 0L) {
            offset = 1024L;
            offset += 8L - offset % 8L;
        } else {
            offset = fileSize;
        }
        this.dataFile.write(buffer, offset).join();
    }

    @Override
    protected Reader delegate() {
        return this.reader;
    }

    @Override
    public Writer truncate() {
        try {
            new RandomAccessFile(this.dataFilePath.toFile(), "rw").getChannel().truncate(0L);
            if (this.revisionsFile != null) {
                new RandomAccessFile(this.revisionsOffsetFilePath.toFile(), "rw").getChannel().truncate(0L);
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        return this;
    }
}

