/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.DataRecord;

public final class HashCountEntryNode
implements DataRecord {
    private final long nodeKey;
    private int value;

    public HashCountEntryNode(long nodeKey, int value) {
        this.nodeKey = nodeKey;
        this.value = value;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.HASH_NAME_COUNT_TO_NAME_ENTRY;
    }

    public int getValue() {
        return this.value;
    }

    public HashCountEntryNode incrementValue() {
        ++this.value;
        return this;
    }

    public HashCountEntryNode decrementValue() {
        --this.value;
        return this;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HashCountEntryNode)) {
            return false;
        }
        HashCountEntryNode other = (HashCountEntryNode)obj;
        return Objects.equal((Object)this.value, (Object)other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    @Override
    public long getNodeKey() {
        return this.nodeKey;
    }

    @Override
    public int getPreviousRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return null;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return null;
    }
}

