/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node;

import io.sirix.access.ResourceConfiguration;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.node.NodeKind;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.node.interfaces.DeweyIdSerializer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NodeSerializerImpl
implements DeweyIdSerializer {
    @Override
    public @NonNull DataRecord deserialize(BytesIn<?> source, @NonNegative long recordID, byte[] deweyID, PageReadOnlyTrx pageReadTrx) {
        byte id = source.readByte();
        NodeKind enumKind = NodeKind.getKind(id);
        return enumKind.deserialize(source, recordID, deweyID, pageReadTrx);
    }

    @Override
    public void serialize(BytesOut<ByteBuffer> sink, DataRecord record, PageReadOnlyTrx pageReadTrx) {
        NodeKind nodeKind = (NodeKind)record.getKind();
        byte id = nodeKind.getId();
        sink.writeByte(id);
        nodeKind.serialize(sink, record, pageReadTrx);
    }

    @Override
    public byte[] deserializeDeweyID(BytesIn<?> source, byte[] previousDeweyID, ResourceConfiguration resourceConfig) {
        if (resourceConfig.areDeweyIDsStored) {
            if (previousDeweyID != null) {
                byte cutOffSize = source.readByte();
                byte size = source.readByte();
                byte[] deweyIDBytes = new byte[size];
                source.read(deweyIDBytes);
                byte[] bytes = new byte[cutOffSize + deweyIDBytes.length];
                ByteBuffer target = ByteBuffer.wrap(bytes);
                target.put(Arrays.copyOfRange(previousDeweyID, 0, (int)cutOffSize));
                target.put(deweyIDBytes);
                return bytes;
            }
            byte deweyIDLength = source.readByte();
            byte[] deweyIDBytes = new byte[deweyIDLength];
            source.read(deweyIDBytes, 0, (int)deweyIDLength);
            return deweyIDBytes;
        }
        return null;
    }

    @Override
    public void serializeDeweyID(BytesOut<?> sink, byte[] deweyID, byte[] nextDeweyID, ResourceConfiguration resourceConfig) {
        if (resourceConfig.areDeweyIDsStored) {
            if (nextDeweyID != null) {
                int i;
                for (i = 0; i < deweyID.length && i < nextDeweyID.length && deweyID[i] == nextDeweyID[i]; ++i) {
                }
                NodeSerializerImpl.writeDeweyID(sink, nextDeweyID, i);
            } else {
                sink.writeByte((byte)deweyID.length);
                sink.write(deweyID);
            }
        }
    }

    private static void writeDeweyID(BytesOut<?> sink, byte[] deweyID, @NonNegative int i) {
        sink.writeByte((byte)i);
        sink.writeByte((byte)(deweyID.length - i));
        byte[] bytes = Arrays.copyOfRange(deweyID, i, deweyID.length);
        sink.write(bytes);
    }
}

