/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.Node;
import io.sirix.settings.Fixed;
import io.sirix.utils.NamePageHash;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NodeDelegate
implements Node {
    private static final int TYPE_KEY = NamePageHash.generateHashForString("xs:untyped");
    private final long nodeKey;
    private byte[] deweyIDData;
    private long parentKey;
    private int typeKey;
    private int previousRevision;
    private int lastModifiedRevision;
    private SirixDeweyID sirixDeweyID;
    private final LongHashFunction hashFunction;

    public NodeDelegate(@NonNegative long nodeKey, long parentKey, LongHashFunction hashFunction, int previousRevision, int lastModifiedRevision, SirixDeweyID deweyID) {
        assert (parentKey >= Fixed.NULL_NODE_KEY.getStandardProperty());
        this.nodeKey = nodeKey;
        this.parentKey = parentKey;
        this.hashFunction = hashFunction;
        this.lastModifiedRevision = lastModifiedRevision;
        this.previousRevision = previousRevision;
        this.typeKey = TYPE_KEY;
        this.sirixDeweyID = deweyID;
    }

    public NodeDelegate(@NonNegative long nodeKey, long parentKey, LongHashFunction hashFunction, int previousRevision, int lastModifiedRevision, byte[] deweyID) {
        assert (parentKey >= Fixed.NULL_NODE_KEY.getStandardProperty());
        this.nodeKey = nodeKey;
        this.parentKey = parentKey;
        this.hashFunction = hashFunction;
        this.previousRevision = previousRevision;
        this.lastModifiedRevision = lastModifiedRevision;
        this.typeKey = TYPE_KEY;
        this.deweyIDData = deweyID;
    }

    public LongHashFunction getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.UNKNOWN;
    }

    @Override
    public long getNodeKey() {
        return this.nodeKey;
    }

    @Override
    public long getParentKey() {
        return this.parentKey;
    }

    @Override
    public void setParentKey(long parentKey) {
        assert (parentKey >= Fixed.NULL_NODE_KEY.getStandardProperty());
        this.parentKey = parentKey;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeKey, this.typeKey, this.parentKey});
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof NodeDelegate)) {
            return false;
        }
        NodeDelegate other = (NodeDelegate)otherObj;
        return Objects.equal((Object)this.nodeKey, (Object)other.nodeKey) && Objects.equal((Object)this.typeKey, (Object)other.typeKey) && Objects.equal((Object)this.parentKey, (Object)other.parentKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node key", this.nodeKey).add("parent key", this.parentKey).add("type key", this.typeKey).add("deweyID", (Object)this.sirixDeweyID).toString();
    }

    public int getTypeKey() {
        return this.typeKey;
    }

    @Override
    public void setTypeKey(int typeKey) {
        this.typeKey = typeKey;
    }

    @Override
    public boolean hasParent() {
        return this.parentKey != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        if (other == null) {
            return false;
        }
        return other.getNodeKey() == this.getNodeKey();
    }

    @Override
    public int getPreviousRevisionNumber() {
        return this.previousRevision;
    }

    @Override
    public int getLastModifiedRevisionNumber() {
        return this.lastModifiedRevision;
    }

    @Override
    public void setPreviousRevision(int previousRevision) {
        this.previousRevision = previousRevision;
    }

    @Override
    public void setLastModifiedRevision(int lastModifiedRevision) {
        this.lastModifiedRevision = lastModifiedRevision;
    }

    @Override
    public void setDeweyID(SirixDeweyID id) {
        this.sirixDeweyID = id;
    }

    @Override
    public synchronized SirixDeweyID getDeweyID() {
        if (this.sirixDeweyID == null && this.deweyIDData != null) {
            this.sirixDeweyID = new SirixDeweyID(this.deweyIDData);
        }
        return this.sirixDeweyID;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        if (this.deweyIDData != null) {
            return this.deweyIDData;
        }
        if (this.sirixDeweyID != null) {
            this.deweyIDData = this.sirixDeweyID.toBytes();
            return this.deweyIDData;
        }
        return null;
    }
}

