/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StructNodeDelegate
extends AbstractForwardingNode
implements StructNode {
    private long firstChild;
    private long lastChild;
    private long rightSibling;
    private long leftSibling;
    private long childCount;
    private long descendantCount;
    private final NodeDelegate nodeDelegate;

    public StructNodeDelegate(NodeDelegate nodeDelegate, long firstChild, long rightSibling, long leftSibling, @NonNegative long childCount, @NonNegative long descendantCount) {
        assert (nodeDelegate != null) : "del must not be null!";
        this.nodeDelegate = nodeDelegate;
        this.firstChild = firstChild;
        this.lastChild = Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty();
        this.rightSibling = rightSibling;
        this.leftSibling = leftSibling;
        this.childCount = childCount;
        this.descendantCount = descendantCount;
    }

    public StructNodeDelegate(NodeDelegate nodeDelegate, long firstChild, long lastChild, long rightSibling, long leftSibling, @NonNegative long childCount, @NonNegative long descendantCount) {
        assert (nodeDelegate != null) : "del must not be null!";
        this.nodeDelegate = nodeDelegate;
        this.firstChild = firstChild;
        this.lastChild = lastChild;
        this.rightSibling = rightSibling;
        this.leftSibling = leftSibling;
        this.childCount = childCount;
        this.descendantCount = descendantCount;
    }

    @Override
    public NodeKind getKind() {
        return this.nodeDelegate.getKind();
    }

    @Override
    public boolean hasFirstChild() {
        return this.firstChild != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasLastChild() {
        return this.lastChild != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty() && this.lastChild != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasLeftSibling() {
        return this.leftSibling != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasRightSibling() {
        return this.rightSibling != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getChildCount() {
        return this.childCount;
    }

    @Override
    public long getFirstChildKey() {
        return this.firstChild;
    }

    @Override
    public long getLastChildKey() {
        return this.lastChild;
    }

    @Override
    public long getLeftSiblingKey() {
        return this.leftSibling;
    }

    @Override
    public long getRightSiblingKey() {
        return this.rightSibling;
    }

    @Override
    public void setRightSiblingKey(long key) {
        this.rightSibling = key;
    }

    @Override
    public void setLeftSiblingKey(long key) {
        this.leftSibling = key;
    }

    @Override
    public void setFirstChildKey(long key) {
        this.firstChild = key;
    }

    @Override
    public void setLastChildKey(long key) {
        if (key == Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            throw new UnsupportedOperationException();
        }
        this.lastChild = key;
    }

    @Override
    public void decrementChildCount() {
        --this.childCount;
    }

    @Override
    public void incrementChildCount() {
        ++this.childCount;
    }

    public int hashCode() {
        return this.lastChild == Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty() ? Objects.hashCode((Object[])new Object[]{this.childCount, this.nodeDelegate, this.firstChild, this.leftSibling, this.rightSibling, this.descendantCount}) : Objects.hashCode((Object[])new Object[]{this.childCount, this.nodeDelegate, this.firstChild, this.lastChild, this.leftSibling, this.rightSibling, this.descendantCount});
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHash(long hash) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StructNodeDelegate)) {
            return false;
        }
        StructNodeDelegate other = (StructNodeDelegate)obj;
        return Objects.equal((Object)this.childCount, (Object)other.childCount) && Objects.equal((Object)this.nodeDelegate, (Object)other.nodeDelegate) && Objects.equal((Object)this.firstChild, (Object)other.firstChild) && Objects.equal((Object)this.lastChild, (Object)other.lastChild) && Objects.equal((Object)this.leftSibling, (Object)other.leftSibling) && Objects.equal((Object)this.rightSibling, (Object)other.rightSibling) && Objects.equal((Object)this.descendantCount, (Object)other.descendantCount);
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("first child", this.getFirstChildKey()).add("last child", this.getLastChildKey()).add("left sib", this.getLeftSiblingKey()).add("right sib", this.getRightSiblingKey()).add("child count", this.getChildCount()).add("descendant count", this.getDescendantCount()).add("node delegate", (Object)this.getNodeDelegate().toString()).toString();
    }

    @Override
    public long getDescendantCount() {
        return this.descendantCount;
    }

    @Override
    public void decrementDescendantCount() {
        --this.descendantCount;
    }

    @Override
    public void incrementDescendantCount() {
        ++this.descendantCount;
    }

    @Override
    public void setDescendantCount(@NonNegative long descendantCount) {
        this.descendantCount = descendantCount;
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        return this.nodeDelegate.isSameItem(other);
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

