/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.json;

import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Constants;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractStringNode
extends AbstractStructForwardingNode
implements ValueNode,
ImmutableJsonNode {
    private final ValueNodeDelegate valueNodeDelegate;
    private final StructNodeDelegate structNodeDelegate;
    private long hashCode;

    public AbstractStringNode(ValueNodeDelegate valueNodeDelegate, StructNodeDelegate structNodeDelegate) {
        this.valueNodeDelegate = valueNodeDelegate;
        this.structNodeDelegate = structNodeDelegate;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)bytes.writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey());
        bytes.writeUtf8(new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING));
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hashCode = hash;
    }

    @Override
    public long getHash() {
        if (this.hashCode == 0L) {
            this.hashCode = this.computeHash((Bytes<ByteBuffer>)Bytes.elasticHeapByteBuffer());
        }
        return this.hashCode;
    }

    @Override
    public byte[] getRawValue() {
        return this.valueNodeDelegate.getRawValue();
    }

    @Override
    public void setRawValue(byte[] value) {
        this.hashCode = 0L;
        this.valueNodeDelegate.setRawValue(value);
    }

    @Override
    public String getValue() {
        return new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public StructNodeDelegate getStructNodeDelegate() {
        return this.structNodeDelegate;
    }

    public ValueNodeDelegate getValNodeDelegate() {
        return this.valueNodeDelegate;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }
}

