/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ArrayNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode {
    private final StructNodeDelegate structNodeDelegate;
    private final long pathNodeKey;
    private long hash;

    public ArrayNode(StructNodeDelegate structNodeDelegate, long pathNodeKey) {
        assert (structNodeDelegate != null);
        this.structNodeDelegate = structNodeDelegate;
        this.pathNodeKey = pathNodeKey;
    }

    public ArrayNode(long hashCode, StructNodeDelegate structNodeDelegate, long pathNodeKey) {
        this.hash = hashCode;
        assert (structNodeDelegate != null);
        this.structNodeDelegate = structNodeDelegate;
        this.pathNodeKey = pathNodeKey;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ARRAY;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getChildCount())).writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("structDelegate", (Object)this.structNodeDelegate).toString();
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectKeyNode)) {
            return false;
        }
        ObjectKeyNode other = (ObjectKeyNode)obj;
        return Objects.equal((Object)this.delegate(), (Object)other.delegate());
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableArrayNode.of(this));
    }

    public long getPathNodeKey() {
        return this.pathNodeKey;
    }
}

