/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.immutable.json.ImmutableNullNode;
import io.sirix.node.json.AbstractNullNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NullNode
extends AbstractNullNode {
    public NullNode(StructNodeDelegate structNodeDelegate) {
        super(structNodeDelegate);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.NULL_VALUE;
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableNullNode.of(this));
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NullNode)) {
            return false;
        }
        NullNode other = (NullNode)obj;
        return Objects.equal((Object)this.delegate(), (Object)other.delegate()) && Objects.equal((Object)this.getHash(), (Object)other.getHash());
    }
}

