/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.json;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.node.NodeKind;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.interfaces.immutable.ImmutableNameNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ObjectKeyNode
extends AbstractStructForwardingNode
implements ImmutableJsonNode,
ImmutableNameNode {
    private final StructNodeDelegate structNodeDelegate;
    private int nameKey;
    private QNm name;
    private long pathNodeKey;
    private long hash;

    public ObjectKeyNode(StructNodeDelegate structDel, int nameKey, String name, long pathNodeKey) {
        assert (structDel != null);
        assert (name != null);
        this.structNodeDelegate = structDel;
        this.nameKey = nameKey;
        this.name = new QNm(name);
        this.pathNodeKey = pathNodeKey;
    }

    public ObjectKeyNode(long hashCode, StructNodeDelegate structDel, int nameKey, String name, long pathNodeKey) {
        this.hash = hashCode;
        assert (structDel != null);
        this.structNodeDelegate = structDel;
        this.nameKey = nameKey;
        this.name = new QNm(name);
        this.pathNodeKey = pathNodeKey;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.OBJECT_KEY;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        bytes.writeInt(this.nameKey);
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    public int getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(int nameKey) {
        this.nameKey = nameKey;
    }

    public void setName(String name) {
        this.name = new QNm(name);
    }

    @Override
    public VisitResult acceptVisitor(JsonNodeVisitor visitor) {
        return visitor.visit(ImmutableObjectKeyNode.of(this));
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("nameKey", this.nameKey).add("structDelegate", (Object)this.structNodeDelegate).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.nameKey, this.delegate()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectKeyNode)) {
            return false;
        }
        ObjectKeyNode other = (ObjectKeyNode)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && this.nameKey == other.nameKey && Objects.equal((Object)this.delegate(), (Object)other.delegate());
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.structNodeDelegate.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    public ObjectKeyNode setPathNodeKey(@NonNegative long pathNodeKey) {
        this.pathNodeKey = pathNodeKey;
        return this;
    }

    @Override
    public int getLocalNameKey() {
        return this.nameKey;
    }

    @Override
    public int getPrefixKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getURIKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPathNodeKey() {
        return this.pathNodeKey;
    }

    @Override
    public QNm getName() {
        return this.name;
    }
}

