/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.immutable.xml.ImmutableAttributeNode;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.settings.Constants;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AttributeNode
extends AbstractForwardingNode
implements ValueNode,
NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate nameNodeDelegate;
    private final ValueNodeDelegate valueNodeDelegate;
    private final NodeDelegate nodeDelegate;
    private final QNm qNm;
    private long hash;

    public AttributeNode(NodeDelegate nodeDel, NameNodeDelegate nameDel, ValueNodeDelegate valDel, QNm qNm) {
        assert (nodeDel != null) : "nodeDel must not be null!";
        this.nodeDelegate = nodeDel;
        assert (nameDel != null) : "nameDel must not be null!";
        this.nameNodeDelegate = nameDel;
        assert (valDel != null) : "valDel must not be null!";
        this.valueNodeDelegate = valDel;
        assert (qNm != null) : "qNm must not be null!";
        this.qNm = qNm;
    }

    public AttributeNode(long hashCode, NodeDelegate nodeDel, NameNodeDelegate nameDel, ValueNodeDelegate valDel, QNm qNm) {
        this.hash = hashCode;
        assert (nodeDel != null) : "nodeDel must not be null!";
        this.nodeDelegate = nodeDel;
        assert (nameDel != null) : "nameDel must not be null!";
        this.nameNodeDelegate = nameDel;
        assert (valDel != null) : "valDel must not be null!";
        this.valueNodeDelegate = valDel;
        assert (qNm != null) : "qNm must not be null!";
        this.qNm = qNm;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ATTRIBUTE;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        byte[] rawValue = this.valueNodeDelegate.getRawValue();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(this.nodeDelegate.getNodeKey())).writeLong(this.nodeDelegate.getParentKey())).writeByte(this.nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)bytes.writeLong((long)this.nameNodeDelegate.getPrefixKey())).writeLong((long)this.nameNodeDelegate.getLocalNameKey())).writeLong((long)this.nameNodeDelegate.getURIKey());
        bytes.write(rawValue);
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return this.nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableAttributeNode.of(this));
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nameDel", (Object)this.nameNodeDelegate).add("valDel", (Object)this.valueNodeDelegate).toString();
    }

    @Override
    public int getPrefixKey() {
        return this.nameNodeDelegate.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.nameNodeDelegate.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.nameNodeDelegate.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setURIKey(uriKey);
    }

    @Override
    public byte[] getRawValue() {
        return this.valueNodeDelegate.getRawValue();
    }

    @Override
    public void setRawValue(byte[] value) {
        this.hash = 0L;
        this.valueNodeDelegate.setRawValue(value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nameNodeDelegate, this.valueNodeDelegate});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AttributeNode) {
            AttributeNode other = (AttributeNode)obj;
            return Objects.equal((Object)this.nameNodeDelegate, (Object)other.nameNodeDelegate) && Objects.equal((Object)this.valueNodeDelegate, (Object)other.valueNodeDelegate);
        }
        return false;
    }

    @Override
    public void setPathNodeKey(@NonNegative long pathNodeKey) {
        this.nameNodeDelegate.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.nameNodeDelegate.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.nameNodeDelegate;
    }

    public ValueNodeDelegate getValNodeDelegate() {
        return this.valueNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public QNm getName() {
        return this.qNm;
    }

    @Override
    public String getValue() {
        return new String(this.valueNodeDelegate.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.nodeDelegate.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.nodeDelegate.getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

