/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.brackit.query.atomic.QNm;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.immutable.xml.ImmutableNamespace;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NamespaceNode
extends AbstractForwardingNode
implements NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate nameNodeDelegate;
    private final NodeDelegate nodeDelegate;
    private final QNm qNm;
    private long hash;

    public NamespaceNode(NodeDelegate nodeDel, NameNodeDelegate nameNodeDelegate, QNm qNm) {
        assert (nodeDel != null);
        assert (nameNodeDelegate != null);
        this.nodeDelegate = nodeDel;
        this.nameNodeDelegate = nameNodeDelegate;
        this.qNm = qNm;
    }

    public NamespaceNode(long hashCode, NodeDelegate nodeDel, NameNodeDelegate nameNodeDelegate, QNm qNm) {
        assert (nodeDel != null);
        assert (nameNodeDelegate != null);
        this.hash = hashCode;
        this.nodeDelegate = nodeDel;
        this.nameNodeDelegate = nameNodeDelegate;
        this.qNm = qNm;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.NAMESPACE;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(this.nodeDelegate.getNodeKey())).writeLong(this.nodeDelegate.getParentKey())).writeByte(this.nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)bytes.writeLong((long)this.nameNodeDelegate.getPrefixKey())).writeLong((long)this.nameNodeDelegate.getLocalNameKey())).writeLong((long)this.nameNodeDelegate.getURIKey());
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return this.nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    @Override
    public int getPrefixKey() {
        return this.nameNodeDelegate.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.nameNodeDelegate.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.nameNodeDelegate.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.hash = 0L;
        this.nameNodeDelegate.setURIKey(uriKey);
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableNamespace.of(this));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeDelegate, this.nameNodeDelegate});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NamespaceNode) {
            NamespaceNode other = (NamespaceNode)obj;
            return Objects.equal((Object)this.nodeDelegate, (Object)other.nodeDelegate) && Objects.equal((Object)this.nameNodeDelegate, (Object)other.nameNodeDelegate);
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeDel", (Object)this.nodeDelegate).add("nameDel", (Object)this.nameNodeDelegate).toString();
    }

    @Override
    public void setPathNodeKey(@NonNegative long pathNodeKey) {
        this.nameNodeDelegate.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.nameNodeDelegate.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.nameNodeDelegate;
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    public QNm getName() {
        return this.qNm;
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.nodeDelegate.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.nodeDelegate.getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

