/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.node.xml;

import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.immutable.xml.ImmutableXmlDocumentRootNode;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AbstractStructForwardingNode;
import io.sirix.settings.Fixed;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class XmlDocumentRootNode
extends AbstractStructForwardingNode
implements StructNode,
ImmutableXmlNode {
    private final NodeDelegate nodeDelegate;
    private final StructNodeDelegate structNodeDelegate;
    private long hash;

    public XmlDocumentRootNode(@NonNull NodeDelegate nodeDelegate, @NonNull StructNodeDelegate structNodeDelegate) {
        this.nodeDelegate = Objects.requireNonNull(nodeDelegate);
        this.structNodeDelegate = Objects.requireNonNull(structNodeDelegate);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.XML_DOCUMENT;
    }

    @Override
    public long computeHash(Bytes<ByteBuffer> bytes) {
        NodeDelegate nodeDelegate = this.structNodeDelegate.getNodeDelegate();
        bytes.clear();
        ((Bytes)((Bytes)bytes.writeLong(nodeDelegate.getNodeKey())).writeLong(nodeDelegate.getParentKey())).writeByte(nodeDelegate.getKind().getId());
        ((Bytes)((Bytes)((Bytes)((Bytes)bytes.writeLong(this.structNodeDelegate.getChildCount())).writeLong(this.structNodeDelegate.getDescendantCount())).writeLong(this.structNodeDelegate.getLeftSiblingKey())).writeLong(this.structNodeDelegate.getRightSiblingKey())).writeLong(this.structNodeDelegate.getFirstChildKey());
        if (this.structNodeDelegate.getLastChildKey() != Fixed.INVALID_KEY_FOR_TYPE_CHECK.getStandardProperty()) {
            bytes.writeLong(this.structNodeDelegate.getLastChildKey());
        }
        ByteBuffer buffer = ((ByteBuffer)bytes.underlyingObject()).rewind();
        buffer.limit((int)bytes.readLimit());
        return nodeDelegate.getHashFunction().hashBytes(buffer);
    }

    @Override
    public void setHash(long hash) {
        this.hash = hash;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableXmlDocumentRootNode.of(this));
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeDelegate});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XmlDocumentRootNode) {
            XmlDocumentRootNode other = (XmlDocumentRootNode)obj;
            return com.google.common.base.Objects.equal((Object)this.nodeDelegate, (Object)other.nodeDelegate);
        }
        return false;
    }

    @Override
    public @NonNull String toString() {
        return super.toString();
    }

    @Override
    protected @NonNull NodeDelegate delegate() {
        return this.nodeDelegate;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.structNodeDelegate;
    }

    @Override
    public SirixDeweyID getDeweyID() {
        return this.nodeDelegate.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.nodeDelegate.getTypeKey();
    }

    @Override
    public byte[] getDeweyIDAsBytes() {
        return this.nodeDelegate.getDeweyIDAsBytes();
    }
}

