/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import com.google.common.base.MoreObjects;
import io.sirix.access.DatabaseType;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.cache.Cache;
import io.sirix.cache.NamesCacheKey;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.index.name.Names;
import io.sirix.node.NodeKind;
import io.sirix.page.AbstractForwardingPage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NamePage
extends AbstractForwardingPage {
    public static final int ATTRIBUTES_REFERENCE_OFFSET = 0;
    public static final int ELEMENTS_REFERENCE_OFFSET = 1;
    public static final int NAMESPACE_REFERENCE_OFFSET = 2;
    public static final int PROCESSING_INSTRUCTION_REFERENCE_OFFSET = 3;
    public static final int JSON_OBJECT_KEY_REFERENCE_OFFSET = 0;
    private Names attributes;
    private Names elements;
    private Names namespaces;
    private Names processingInstructions;
    private Names jsonObjectKeys;
    private Page delegate;
    private final int numberOfArrays;
    private final Int2LongMap maxNodeKeys;
    private final Int2IntMap currentMaxLevelsOfIndirectPages;

    public NamePage() {
        this.delegate = new ReferencesPage4();
        this.maxNodeKeys = new Int2LongOpenHashMap();
        this.attributes = Names.getInstance(0);
        this.elements = Names.getInstance(1);
        this.namespaces = Names.getInstance(2);
        this.processingInstructions = Names.getInstance(3);
        this.jsonObjectKeys = Names.getInstance(0);
        this.currentMaxLevelsOfIndirectPages = new Int2IntOpenHashMap();
        this.numberOfArrays = 0;
    }

    NamePage(Page delegate, Int2LongMap maxNodeKeys, Int2IntMap currentMaxLevelsOfIndirectPages, int numberOfArrays) {
        this.delegate = delegate;
        this.maxNodeKeys = maxNodeKeys;
        this.currentMaxLevelsOfIndirectPages = currentMaxLevelsOfIndirectPages;
        this.numberOfArrays = numberOfArrays;
    }

    public byte[] getRawName(int key, NodeKind nodeKind, PageReadOnlyTrx pageRtx) {
        return switch (nodeKind) {
            case NodeKind.ELEMENT -> {
                if (this.elements == null) {
                    this.elements = this.getNames(pageRtx, 1);
                }
                yield this.elements.getRawName(key);
            }
            case NodeKind.NAMESPACE -> {
                if (this.namespaces == null) {
                    this.namespaces = this.getNames(pageRtx, 2);
                }
                yield this.namespaces.getRawName(key);
            }
            case NodeKind.ATTRIBUTE -> {
                if (this.attributes == null) {
                    this.attributes = this.getNames(pageRtx, 0);
                }
                yield this.attributes.getRawName(key);
            }
            case NodeKind.PROCESSING_INSTRUCTION -> {
                if (this.processingInstructions == null) {
                    this.processingInstructions = this.getNames(pageRtx, 3);
                }
                yield this.processingInstructions.getRawName(key);
            }
            case NodeKind.OBJECT_KEY -> {
                if (this.jsonObjectKeys == null) {
                    this.jsonObjectKeys = this.getNames(pageRtx, 0);
                }
                yield this.jsonObjectKeys.getRawName(key);
            }
            default -> throw new IllegalStateException("No other node types supported!");
        };
    }

    private Names getNames(PageReadOnlyTrx pageRtx, int offset) {
        NamesCacheKey namesCacheKey;
        long maxNodeKey = this.maxNodeKeys.getOrDefault(offset, 0L);
        if (pageRtx.hasTrxIntentLog()) {
            return Names.fromStorage(pageRtx, offset, maxNodeKey);
        }
        Cache<NamesCacheKey, Names> namesCache = pageRtx.getBufferManager().getNamesCache();
        Names names = namesCache.get(namesCacheKey = new NamesCacheKey(pageRtx.getRevisionNumber(), offset));
        if (names == null) {
            names = Names.fromStorage(pageRtx, offset, maxNodeKey);
            namesCache.put(namesCacheKey, names);
        } else {
            names = Names.copy(names);
        }
        return names;
    }

    public String getName(int key, @NonNull NodeKind nodeKind, PageReadOnlyTrx pageRtx) {
        return switch (nodeKind) {
            case NodeKind.ELEMENT -> {
                if (this.elements == null) {
                    this.elements = this.getNames(pageRtx, 1);
                }
                yield this.elements.getName(key);
            }
            case NodeKind.NAMESPACE -> {
                if (this.namespaces == null) {
                    this.namespaces = this.getNames(pageRtx, 2);
                }
                yield this.namespaces.getName(key);
            }
            case NodeKind.ATTRIBUTE -> {
                if (this.attributes == null) {
                    this.attributes = this.getNames(pageRtx, 0);
                }
                yield this.attributes.getName(key);
            }
            case NodeKind.PROCESSING_INSTRUCTION -> {
                if (this.processingInstructions == null) {
                    this.processingInstructions = this.getNames(pageRtx, 3);
                }
                yield this.processingInstructions.getName(key);
            }
            case NodeKind.OBJECT_KEY -> {
                if (this.jsonObjectKeys == null) {
                    this.jsonObjectKeys = this.getNames(pageRtx, 0);
                }
                yield this.jsonObjectKeys.getName(key);
            }
            case NodeKind.ARRAY -> "__array__";
            case NodeKind.OBJECT -> "__object__";
            default -> throw new IllegalStateException("No other node types supported!");
        };
    }

    public int getCount(int key, @NonNull NodeKind nodeKind, PageReadOnlyTrx pageRtx) {
        return switch (nodeKind) {
            case NodeKind.ELEMENT -> {
                if (this.elements == null) {
                    this.elements = this.getNames(pageRtx, 1);
                }
                yield this.elements.getCount(key);
            }
            case NodeKind.NAMESPACE -> {
                if (this.namespaces == null) {
                    this.namespaces = this.getNames(pageRtx, 2);
                }
                yield this.namespaces.getCount(key);
            }
            case NodeKind.ATTRIBUTE -> {
                if (this.attributes == null) {
                    this.attributes = this.getNames(pageRtx, 0);
                }
                yield this.attributes.getCount(key);
            }
            case NodeKind.PROCESSING_INSTRUCTION -> {
                if (this.processingInstructions == null) {
                    this.processingInstructions = this.getNames(pageRtx, 3);
                }
                yield this.processingInstructions.getCount(key);
            }
            case NodeKind.OBJECT_KEY -> {
                if (this.jsonObjectKeys == null) {
                    this.jsonObjectKeys = this.getNames(pageRtx, 0);
                }
                yield this.jsonObjectKeys.getCount(key);
            }
            case NodeKind.ARRAY -> this.numberOfArrays;
            default -> throw new IllegalStateException("No other node types supported!");
        };
    }

    public int setName(String name, NodeKind nodeKind, PageTrx pageRtx) {
        switch (nodeKind) {
            case ELEMENT: {
                if (this.elements == null) {
                    this.elements = this.getNames(pageRtx, 1);
                }
                return this.elements.setName(name, pageRtx);
            }
            case NAMESPACE: {
                if (this.namespaces == null) {
                    this.namespaces = this.getNames(pageRtx, 2);
                }
                return this.namespaces.setName(name, pageRtx);
            }
            case ATTRIBUTE: {
                if (this.attributes == null) {
                    this.attributes = this.getNames(pageRtx, 0);
                }
                return this.attributes.setName(name, pageRtx);
            }
            case PROCESSING_INSTRUCTION: {
                if (this.processingInstructions == null) {
                    this.processingInstructions = this.getNames(pageRtx, 3);
                }
                return this.processingInstructions.setName(name, pageRtx);
            }
            case OBJECT_KEY: {
                if (this.jsonObjectKeys == null) {
                    this.jsonObjectKeys = this.getNames(pageRtx, 0);
                }
                return this.jsonObjectKeys.setName(name, pageRtx);
            }
        }
        throw new IllegalStateException("No other node types supported!");
    }

    public int getCurrentMaxLevelOfIndirectPagesSize() {
        return this.currentMaxLevelsOfIndirectPages.size();
    }

    public int getCurrentMaxLevelOfIndirectPages(int index) {
        return this.currentMaxLevelsOfIndirectPages.get(index);
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages(int index) {
        return this.currentMaxLevelsOfIndirectPages.merge(index, 1, Integer::sum);
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("elements", (Object)this.elements).add("attributes", (Object)this.attributes).add("URIs", (Object)this.namespaces).add("PIs", (Object)this.processingInstructions).toString();
    }

    public void removeName(int key, NodeKind nodeKind, PageTrx pageRtx) {
        switch (nodeKind) {
            case ELEMENT: {
                if (this.elements == null) {
                    this.elements = this.getNames(pageRtx, 1);
                }
                this.elements.removeName(key, pageRtx);
                break;
            }
            case NAMESPACE: {
                if (this.namespaces == null) {
                    this.namespaces = this.getNames(pageRtx, 2);
                }
                this.namespaces.removeName(key, pageRtx);
                break;
            }
            case ATTRIBUTE: {
                if (this.attributes == null) {
                    this.attributes = this.getNames(pageRtx, 0);
                }
                this.attributes.removeName(key, pageRtx);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                if (this.processingInstructions == null) {
                    this.processingInstructions = this.getNames(pageRtx, 3);
                }
                this.processingInstructions.removeName(key, pageRtx);
                break;
            }
            case OBJECT_KEY: {
                if (this.jsonObjectKeys == null) {
                    this.jsonObjectKeys = this.getNames(pageRtx, 0);
                }
                this.jsonObjectKeys.removeName(key, pageRtx);
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
    }

    public void createNameIndexTree(DatabaseType databaseType, PageReadOnlyTrx pageReadTrx, int index, TransactionIntentLog log) {
        PageReference reference = this.getOrCreateReference(index);
        if (reference == null) {
            this.delegate = new BitmapReferencesPage(1024, (ReferencesPage4)this.delegate());
            reference = this.delegate.getOrCreateReference(index);
        }
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15) {
            PageUtils.createTree(databaseType, reference, IndexType.NAME, pageReadTrx, log);
            if (this.maxNodeKeys.get(index) == 0L) {
                this.maxNodeKeys.put(index, 0L);
            } else {
                this.maxNodeKeys.put(index, this.maxNodeKeys.get(index) + 1L);
            }
            this.currentMaxLevelsOfIndirectPages.merge(index, 1, Integer::sum);
        }
    }

    public PageReference getIndirectPageReference(int offset) {
        return this.getOrCreateReference(offset);
    }

    public int getNumberOfArrays() {
        return this.numberOfArrays;
    }

    public long getMaxNodeKey(int indexNumber) {
        return this.maxNodeKeys.get(indexNumber);
    }

    public int getMaxNodeKeySize() {
        return this.maxNodeKeys.size();
    }

    public long incrementAndGetMaxNodeKey(int indexNumber) {
        long newMaxNodeKey = this.maxNodeKeys.getOrDefault(indexNumber, 0L) + 1L;
        this.maxNodeKeys.put(indexNumber, newMaxNodeKey);
        return newMaxNodeKey;
    }

    @Override
    protected Page delegate() {
        return this.delegate;
    }

    @Override
    public boolean setOrCreateReference(int offset, PageReference pageReference) {
        this.delegate = PageUtils.setReference(this.delegate, offset, pageReference);
        return false;
    }
}

