/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import io.sirix.BinaryEncodingVersion;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.User;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.index.IndexType;
import io.sirix.io.Reader;
import io.sirix.node.Utils;
import io.sirix.node.interfaces.DeweyIdSerializer;
import io.sirix.node.interfaces.RecordSerializer;
import io.sirix.page.CASPage;
import io.sirix.page.DeweyIDPage;
import io.sirix.page.IndirectPage;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.NamePage;
import io.sirix.page.OverflowPage;
import io.sirix.page.PageReference;
import io.sirix.page.PageUtils;
import io.sirix.page.PathPage;
import io.sirix.page.PathSummaryPage;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.delegates.FullReferencesPage;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import io.sirix.settings.Constants;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum PageKind {
    KEYVALUELEAFPAGE(1, KeyValueLeafPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    int index;
                    long recordPageKey = Utils.getVarLong(source);
                    int revision = source.readInt();
                    IndexType indexType = IndexType.getType(source.readByte());
                    ResourceConfiguration resourceConfig = pageReadTrx.getResourceSession().getResourceConfig();
                    boolean areDeweyIDsStored = resourceConfig.areDeweyIDsStored;
                    RecordSerializer recordPersister = resourceConfig.recordPersister;
                    byte[][] slots = new byte[1024][];
                    byte[][] deweyIds = new byte[1024][];
                    if (resourceConfig.areDeweyIDsStored && recordPersister instanceof DeweyIdSerializer) {
                        boolean hasDeweyIds;
                        DeweyIdSerializer serializer = (DeweyIdSerializer)recordPersister;
                        BitSet deweyIdsBitmap = SerializationType.deserializeBitSet(source);
                        int deweyIdsSize = source.readInt();
                        boolean bl = hasDeweyIds = deweyIdsSize != 0;
                        if (hasDeweyIds) {
                            int setBit = -1;
                            byte[] deweyId = null;
                            for (index = 0; index < deweyIdsSize; ++index) {
                                setBit = deweyIdsBitmap.nextSetBit(setBit + 1);
                                assert (setBit >= 0);
                                if (recordPageKey == 0L && setBit == 0) continue;
                                deweyId = serializer.deserializeDeweyID(source, deweyId, resourceConfig);
                                deweyIds[setBit] = deweyId;
                            }
                        }
                    }
                    BitSet entriesBitmap = SerializationType.deserializeBitSet(source);
                    BitSet overlongEntriesBitmap = SerializationType.deserializeBitSet(source);
                    int normalEntrySize = source.readInt();
                    int setBit = -1;
                    for (int index2 = 0; index2 < normalEntrySize; ++index2) {
                        setBit = entriesBitmap.nextSetBit(setBit + 1);
                        assert (setBit >= 0);
                        long key = (recordPageKey << 10) + (long)setBit;
                        int dataSize = source.readInt();
                        assert (dataSize > 0);
                        byte[] data = new byte[dataSize];
                        source.read(data);
                        int offset = PageReadOnlyTrx.recordPageOffset(key);
                        slots[offset] = data;
                    }
                    int overlongEntrySize = source.readInt();
                    LinkedHashMap<Long, PageReference> references = new LinkedHashMap<Long, PageReference>(overlongEntrySize);
                    setBit = -1;
                    for (index = 0; index < overlongEntrySize; ++index) {
                        setBit = overlongEntriesBitmap.nextSetBit(setBit + 1);
                        assert (setBit >= 0);
                        long key = (recordPageKey << 10) + (long)setBit;
                        PageReference reference = new PageReference();
                        reference.setKey(source.readLong());
                        references.put(key, reference);
                    }
                    return new KeyValueLeafPage(recordPageKey, revision, indexType, resourceConfig, areDeweyIDsStored, recordPersister, slots, deweyIds, references);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            byte[] serializedPage;
            KeyValueLeafPage keyValueLeafPage = (KeyValueLeafPage)page;
            BytesOut<?> bytes = keyValueLeafPage.getBytes();
            if (bytes != null) {
                sink.write((BytesStore)bytes.bytesForWrite());
                return;
            }
            sink.writeByte(1.KEYVALUELEAFPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            long recordPageKey = keyValueLeafPage.getPageKey();
            IndexType indexType = keyValueLeafPage.getIndexType();
            ResourceConfiguration resourceConfig = keyValueLeafPage.getResourceConfig();
            RecordSerializer recordPersister = resourceConfig.recordPersister;
            byte[][] deweyIds = keyValueLeafPage.getDeweyIds();
            byte[][] slots = keyValueLeafPage.getSlots();
            Map<Long, PageReference> references = keyValueLeafPage.getReferencesMap();
            keyValueLeafPage.addReferences(pageReadOnlyTrx);
            Utils.putVarLong(sink, recordPageKey);
            sink.writeInt(pageReadOnlyTrx.getRevisionNumber());
            sink.writeByte(indexType.getID());
            if (resourceConfig.areDeweyIDsStored && recordPersister instanceof DeweyIdSerializer) {
                DeweyIdSerializer persistence = (DeweyIdSerializer)recordPersister;
                BitSet deweyIdsBitmap = new BitSet(1024);
                for (int i = 0; i < deweyIds.length; ++i) {
                    if (deweyIds[i] == null) continue;
                    deweyIdsBitmap.set(i);
                }
                SerializationType.serializeBitSet(sink, deweyIdsBitmap);
                sink.writeInt(deweyIdsBitmap.cardinality());
                boolean first = true;
                Iterator previousDeweyId = null;
                for (byte[] deweyId : deweyIds) {
                    if (deweyId == null) continue;
                    if (first) {
                        first = false;
                        persistence.serializeDeweyID(sink, deweyId, null, resourceConfig);
                    } else {
                        persistence.serializeDeweyID(sink, (byte[])previousDeweyId, deweyId, resourceConfig);
                    }
                    previousDeweyId = (Iterator)deweyId;
                }
            }
            BitSet entriesBitmap = new BitSet(1024);
            for (int i = 0; i < slots.length; ++i) {
                if (slots[i] == null) continue;
                entriesBitmap.set(i);
            }
            SerializationType.serializeBitSet(sink, entriesBitmap);
            BitSet overlongEntriesBitmap = new BitSet(1024);
            List overlongEntriesSortedByKey = references.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
            for (Map.Entry entry : overlongEntriesSortedByKey) {
                int pageOffset = PageReadOnlyTrx.recordPageOffset((Long)entry.getKey());
                overlongEntriesBitmap.set(pageOffset);
            }
            SerializationType.serializeBitSet(sink, overlongEntriesBitmap);
            sink.writeInt(entriesBitmap.cardinality());
            for (Object data : (Iterator)slots) {
                if (data == null) continue;
                int length = ((Object)data).length;
                sink.writeInt(length);
                sink.write((byte[])data);
            }
            sink.writeInt(overlongEntriesSortedByKey.size());
            for (Map.Entry entry : overlongEntriesSortedByKey) {
                sink.writeLong(((PageReference)entry.getValue()).getKey());
            }
            pageReadOnlyTrx.getReader();
            keyValueLeafPage.setHashCode(Reader.hashFunction.hashBytes(sink.bytesForRead().toByteArray()).asBytes());
            byte[] byteArray = sink.bytesForRead().toByteArray();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(byteArray.length);){
                try (DataOutputStream dataOutput = new DataOutputStream(pageReadOnlyTrx.getResourceSession().getResourceConfig().byteHandlePipeline.serialize(output));){
                    dataOutput.write(byteArray);
                    dataOutput.flush();
                }
                serializedPage = output.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            keyValueLeafPage.setBytes((BytesOut<?>)Bytes.wrapForRead((byte[])serializedPage));
        }

        @Override
        public @NonNull Page getInstance(Page nodePage, PageReadOnlyTrx pageReadTrx) {
            assert (nodePage instanceof KeyValueLeafPage);
            KeyValueLeafPage page = (KeyValueLeafPage)nodePage;
            return new KeyValueLeafPage(page.getPageKey(), page.getIndexType(), pageReadTrx);
        }
    }
    ,
    NAMEPAGE(2, NamePage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    Int2LongMap maxNodeKeys = PageKind.deserializeMaxNodeKeys(source);
                    int numberOfArrays = source.readInt();
                    Int2IntMap currentMaxLevelsOfIndirectPages = PageKind.deserializeCurrentMaxLevelsOfIndirectPages(source);
                    return new NamePage(delegate, maxNodeKeys, currentMaxLevelsOfIndirectPages, numberOfArrays);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            NamePage namePage = (NamePage)page;
            sink.writeByte(2.NAMEPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            Page delegate = namePage.delegate();
            PageKind.writeDelegateType(delegate, sink);
            PageKind.serializeDelegate(sink, delegate, type);
            int maxNodeKeySize = namePage.getMaxNodeKeySize();
            sink.writeInt(maxNodeKeySize);
            for (int i = 0; i < maxNodeKeySize; ++i) {
                long keys = namePage.getMaxNodeKey(i);
                sink.writeLong(keys);
            }
            sink.writeInt(namePage.getNumberOfArrays());
            int currentMaxLevelOfIndirectPagesSize = namePage.getCurrentMaxLevelOfIndirectPagesSize();
            sink.writeInt(currentMaxLevelOfIndirectPagesSize);
            for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
                sink.writeByte((byte)namePage.getCurrentMaxLevelOfIndirectPages(i));
            }
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new NamePage();
        }
    }
    ,
    UBERPAGE(3, UberPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    int revisionCount = source.readInt();
                    return new UberPage(revisionCount);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            UberPage uberPage = (UberPage)page;
            sink.writeByte(3.UBERPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            sink.writeInt(uberPage.getRevisionCount());
            uberPage.setBootstrap(false);
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new UberPage();
        }
    }
    ,
    INDIRECTPAGE(4, IndirectPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    return new IndirectPage(delegate);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            IndirectPage indirectPage = (IndirectPage)page;
            Page delegate = indirectPage.delegate();
            sink.writeByte(4.INDIRECTPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            PageKind.writeDelegateType(delegate, sink);
            PageKind.serializeDelegate(sink, delegate, type);
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new IndirectPage();
        }
    }
    ,
    REVISIONROOTPAGE(5, RevisionRootPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    BitmapReferencesPage delegate = new BitmapReferencesPage(8, source, type);
                    int revision = source.readInt();
                    long maxNodeKeyInDocumentIndex = source.readLong();
                    long maxNodeKeyInChangedNodesIndex = source.readLong();
                    long maxNodeKeyInRecordToRevisionsIndex = source.readLong();
                    long revisionTimestamp = source.readLong();
                    String commitMessage = null;
                    User user = null;
                    if (source.readBoolean()) {
                        byte[] commitMessageBytes = new byte[source.readInt()];
                        source.read(commitMessageBytes);
                        commitMessage = new String(commitMessageBytes, Constants.DEFAULT_ENCODING);
                    }
                    int currentMaxLevelOfDocumentIndexIndirectPages = source.readByte() & 0xFF;
                    int currentMaxLevelOfChangedNodesIndirectPages = source.readByte() & 0xFF;
                    int currentMaxLevelOfRecordToRevisionsIndirectPages = source.readByte() & 0xFF;
                    if (source.readBoolean()) {
                        user = new User(source.readUtf8(), UUID.fromString(source.readUtf8()));
                    }
                    return new RevisionRootPage(delegate, revision, maxNodeKeyInDocumentIndex, maxNodeKeyInChangedNodesIndex, maxNodeKeyInRecordToRevisionsIndex, revisionTimestamp, commitMessage, currentMaxLevelOfDocumentIndexIndirectPages, currentMaxLevelOfChangedNodesIndirectPages, currentMaxLevelOfRecordToRevisionsIndirectPages, user);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            RevisionRootPage revisionRootPage = (RevisionRootPage)page;
            sink.writeByte(5.REVISIONROOTPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            Page delegate = revisionRootPage.delegate();
            PageKind.serializeDelegate(sink, delegate, type);
            Instant commitTimestamp = revisionRootPage.getCommitTimestamp();
            int revision = revisionRootPage.getRevision();
            long maxNodeKeyInDocumentIndex = revisionRootPage.getMaxNodeKeyInDocumentIndex();
            long maxNodeKeyInChangedNodesIndex = revisionRootPage.getMaxNodeKeyInChangedNodesIndex();
            long maxNodeKeyInRecordToRevisionsIndex = revisionRootPage.getMaxNodeKeyInRecordToRevisionsIndex();
            String commitMessage = revisionRootPage.getCommitMessage();
            int currentMaxLevelOfDocumentIndexIndirectPages = revisionRootPage.getCurrentMaxLevelOfDocumentIndexIndirectPages();
            int currentMaxLevelOfChangedNodesIndirectPages = revisionRootPage.getCurrentMaxLevelOfChangedNodesIndexIndirectPages();
            int currentMaxLevelOfRecordToRevisionsIndirectPages = revisionRootPage.getCurrentMaxLevelOfRecordToRevisionsIndexIndirectPages();
            long revisionTimestamp = commitTimestamp == null ? Instant.now().toEpochMilli() : commitTimestamp.toEpochMilli();
            revisionRootPage.setRevisionTimestamp(revisionTimestamp);
            sink.writeInt(revision);
            sink.writeLong(maxNodeKeyInDocumentIndex);
            sink.writeLong(maxNodeKeyInChangedNodesIndex);
            sink.writeLong(maxNodeKeyInRecordToRevisionsIndex);
            sink.writeLong(revisionTimestamp);
            sink.writeBoolean(commitMessage != null);
            if (commitMessage != null) {
                byte[] commitMessageBytes = commitMessage.getBytes(Constants.DEFAULT_ENCODING);
                sink.writeInt(commitMessageBytes.length);
                sink.write(commitMessageBytes);
            }
            sink.writeByte((byte)currentMaxLevelOfDocumentIndexIndirectPages);
            sink.writeByte((byte)currentMaxLevelOfChangedNodesIndirectPages);
            sink.writeByte((byte)currentMaxLevelOfRecordToRevisionsIndirectPages);
            Optional<User> user = revisionRootPage.getUser();
            boolean hasUser = user.isPresent();
            sink.writeBoolean(hasUser);
            if (hasUser) {
                User currUser = user.get();
                sink.writeUtf8(currUser.getName());
                sink.writeUtf8(currUser.getId().toString());
            }
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new RevisionRootPage();
        }
    }
    ,
    PATHSUMMARYPAGE(6, PathSummaryPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, @NonNull SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    int maxNodeKeysSize = source.readInt();
                    Int2LongOpenHashMap maxNodeKeys = new Int2LongOpenHashMap(maxNodeKeysSize);
                    for (int i = 0; i < maxNodeKeysSize; ++i) {
                        maxNodeKeys.put(i, source.readLong());
                    }
                    int currentMaxLevelOfIndirectPagesSize = source.readInt();
                    Int2IntOpenHashMap currentMaxLevelsOfIndirectPages = new Int2IntOpenHashMap(currentMaxLevelOfIndirectPagesSize);
                    for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
                        currentMaxLevelsOfIndirectPages.put(i, source.readByte() & 0xFF);
                    }
                    return new PathSummaryPage(delegate, (Int2LongMap)maxNodeKeys, (Int2IntMap)currentMaxLevelsOfIndirectPages);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, @NonNull SerializationType type) {
            PathSummaryPage pathSummaryPage = (PathSummaryPage)page;
            sink.writeByte(6.PATHSUMMARYPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            sink.writeByte((byte)0);
            Page delegate = pathSummaryPage.delegate();
            PageKind.serializeDelegate(sink, delegate, type);
            int maxNodeKeySize = pathSummaryPage.getMaxNodeKeySize();
            sink.writeInt(maxNodeKeySize);
            for (int i = 0; i < maxNodeKeySize; ++i) {
                sink.writeLong(pathSummaryPage.getMaxNodeKey(i));
            }
            int currentMaxLevelOfIndirectPagesSize = pathSummaryPage.getCurrentMaxLevelOfIndirectPagesSize();
            sink.writeInt(currentMaxLevelOfIndirectPagesSize);
            for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
                sink.writeByte((byte)pathSummaryPage.getCurrentMaxLevelOfIndirectPages(i));
            }
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new PathSummaryPage();
        }
    }
    ,
    CASPAGE(8, CASPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    Int2LongMap maxNodeKeys = PageKind.deserializeMaxNodeKeys(source);
                    Int2IntMap currentMaxLevelsOfIndirectPages = PageKind.deserializeCurrentMaxLevelsOfIndirectPages(source);
                    return new CASPage(delegate, maxNodeKeys, currentMaxLevelsOfIndirectPages);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, SerializationType type) {
            CASPage casPage = (CASPage)page;
            Page delegate = casPage.delegate();
            sink.writeByte(7.CASPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            PageKind.writeDelegateType(delegate, sink);
            PageKind.serializeDelegate(sink, delegate, type);
            int maxNodeKeySize = casPage.getMaxNodeKeySize();
            sink.writeInt(maxNodeKeySize);
            for (int i = 0; i < maxNodeKeySize; ++i) {
                sink.writeLong(casPage.getMaxNodeKey(i));
            }
            int currentMaxLevelOfIndirectPagesSize = casPage.getCurrentMaxLevelOfIndirectPagesSize();
            sink.writeInt(currentMaxLevelOfIndirectPagesSize);
            for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
                sink.writeByte((byte)casPage.getCurrentMaxLevelOfIndirectPages(i));
            }
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new CASPage();
        }
    }
    ,
    OVERFLOWPAGE(9, OverflowPage.class){

        @Override
        public @NonNull Page deserializePage(PageReadOnlyTrx pageReadTrx, BytesIn<?> source, SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    byte[] data = new byte[source.readInt()];
                    source.read(data);
                    return new OverflowPage(data);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, Page page, @NonNull SerializationType type) {
            OverflowPage overflowPage = (OverflowPage)page;
            sink.writeByte(8.OVERFLOWPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            sink.writeInt(overflowPage.getData().length);
            sink.write(overflowPage.getData());
        }

        @Override
        public @NonNull Page getInstance(Page page, PageReadOnlyTrx pageReadTrx) {
            return new OverflowPage();
        }
    }
    ,
    PATHPAGE(10, PathPage.class){

        @Override
        public Page deserializePage(@NonNull PageReadOnlyTrx pageReadTrx, BytesIn<?> source, @NonNull SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    Int2LongMap maxNodeKeys = PageKind.deserializeMaxNodeKeys(source);
                    Int2IntMap currentMaxLevelsOfIndirectPages = PageKind.deserializeCurrentMaxLevelsOfIndirectPages(source);
                    return new PathPage(delegate, maxNodeKeys, currentMaxLevelsOfIndirectPages);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, @NonNull Page page, @NonNull SerializationType type) {
            PathPage pathPage = (PathPage)page;
            Page delegate = pathPage.delegate();
            sink.writeByte(9.PATHPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            PageKind.writeDelegateType(delegate, sink);
            PageKind.serializeDelegate(sink, delegate, type);
            int maxNodeKeysSize = pathPage.getMaxNodeKeySize();
            sink.writeInt(maxNodeKeysSize);
            for (int i = 0; i < maxNodeKeysSize; ++i) {
                sink.writeLong(pathPage.getMaxNodeKey(i));
            }
            int currentMaxLevelOfIndirectPagesSize = pathPage.getCurrentMaxLevelOfIndirectPagesSize();
            sink.writeInt(currentMaxLevelOfIndirectPagesSize);
            for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
                sink.writeByte((byte)pathPage.getCurrentMaxLevelOfIndirectPages(i));
            }
        }

        @Override
        public @NonNull Page getInstance(Page page, @NonNull PageReadOnlyTrx pageReadTrx) {
            return new PathPage();
        }
    }
    ,
    DEWEYIDPAGE(11, DeweyIDPage.class){

        @Override
        public Page deserializePage(@NonNull PageReadOnlyTrx pageReadTrx, BytesIn<?> source, @NonNull SerializationType type) {
            BinaryEncodingVersion binaryVersion = BinaryEncodingVersion.fromByte(source.readByte());
            switch (binaryVersion) {
                case V0: {
                    Page delegate = PageUtils.createDelegate(source, type);
                    long maxNodeKey = source.readLong();
                    int currentMaxLevelOfIndirectPages = source.readByte() & 0xFF;
                    return new DeweyIDPage(delegate, maxNodeKey, currentMaxLevelOfIndirectPages);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void serializePage(@NonNull PageReadOnlyTrx pageReadOnlyTrx, BytesOut<?> sink, @NonNull Page page, @NonNull SerializationType type) {
            DeweyIDPage deweyIDPage = (DeweyIDPage)page;
            Page delegate = deweyIDPage.delegate();
            sink.writeByte(10.DEWEYIDPAGE.id);
            sink.writeByte(pageReadOnlyTrx.getResourceSession().getResourceConfig().getBinaryEncodingVersion().byteVersion());
            PageKind.writeDelegateType(delegate, sink);
            PageKind.serializeDelegate(sink, delegate, type);
            sink.writeLong(deweyIDPage.getMaxNodeKey());
            sink.writeByte((byte)deweyIDPage.getCurrentMaxLevelOfIndirectPages());
        }

        @Override
        public @NonNull Page getInstance(Page page, @NonNull PageReadOnlyTrx pageReadTrx) {
            return new DeweyIDPage();
        }
    };

    private static final Map<Byte, PageKind> INSTANCEFORID;
    private static final Map<Class<? extends Page>, PageKind> INSTANCEFORCLASS;
    private final byte id;
    private final Class<? extends Page> clazz;

    private static void writeDelegateType(Page delegate, BytesOut<?> sink) {
        Page page = delegate;
        Objects.requireNonNull(page);
        Page page2 = page;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReferencesPage4.class, BitmapReferencesPage.class, FullReferencesPage.class}, (Object)page2, n)) {
            case 0: {
                ReferencesPage4 ignored = (ReferencesPage4)page2;
                sink.writeByte((byte)0);
                break;
            }
            case 1: {
                BitmapReferencesPage ignored = (BitmapReferencesPage)page2;
                sink.writeByte((byte)1);
                break;
            }
            case 2: {
                FullReferencesPage ignored = (FullReferencesPage)page2;
                sink.writeByte((byte)2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(delegate));
            }
        }
    }

    private static void serializeDelegate(BytesOut<?> sink, Page delegate, SerializationType type) {
        Page page = delegate;
        Objects.requireNonNull(page);
        Page page2 = page;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReferencesPage4.class, BitmapReferencesPage.class, FullReferencesPage.class}, (Object)page2, n)) {
            case 0: {
                ReferencesPage4 page3 = (ReferencesPage4)page2;
                type.serializeReferencesPage4(sink, page3.getReferences(), (List<Short>)page3.getOffsets());
                break;
            }
            case 1: {
                BitmapReferencesPage page4 = (BitmapReferencesPage)page2;
                type.serializeBitmapReferencesPage(sink, page4.getReferences(), page4.getBitmap());
                break;
            }
            case 2: {
                FullReferencesPage ignored = (FullReferencesPage)page2;
                type.serializeFullReferencesPage(sink, ((FullReferencesPage)delegate).getReferencesArray());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(delegate));
            }
        }
    }

    private static Int2LongMap deserializeMaxNodeKeys(BytesIn<?> source) {
        int maxNodeKeysSize = source.readInt();
        Int2LongOpenHashMap maxNodeKeys = new Int2LongOpenHashMap((int)Math.ceil((double)maxNodeKeysSize / 0.75));
        for (int i = 0; i < maxNodeKeysSize; ++i) {
            maxNodeKeys.put(i, source.readLong());
        }
        return maxNodeKeys;
    }

    private static Int2IntMap deserializeCurrentMaxLevelsOfIndirectPages(BytesIn<?> source) {
        int currentMaxLevelOfIndirectPagesSize = source.readInt();
        Int2IntOpenHashMap currentMaxLevelsOfIndirectPages = new Int2IntOpenHashMap((int)Math.ceil((double)currentMaxLevelOfIndirectPagesSize / 0.75));
        for (int i = 0; i < currentMaxLevelOfIndirectPagesSize; ++i) {
            currentMaxLevelsOfIndirectPages.put(i, source.readByte() & 0xFF);
        }
        return currentMaxLevelsOfIndirectPages;
    }

    private PageKind(byte id, Class<? extends Page> clazz) {
        this.id = id;
        this.clazz = clazz;
    }

    public byte getID() {
        return this.id;
    }

    public abstract void serializePage(PageReadOnlyTrx var1, BytesOut<?> var2, Page var3, SerializationType var4);

    public abstract Page deserializePage(PageReadOnlyTrx var1, BytesIn<?> var2, SerializationType var3);

    public static PageKind getKind(byte id) {
        PageKind page = INSTANCEFORID.get(id);
        if (page == null) {
            throw new IllegalStateException();
        }
        return page;
    }

    public static @NonNull PageKind getKind(Class<? extends Page> clazz) {
        PageKind page = INSTANCEFORCLASS.get(clazz);
        if (page == null) {
            throw new IllegalStateException();
        }
        return page;
    }

    public abstract @NonNull Page getInstance(Page var1, PageReadOnlyTrx var2);

    static {
        INSTANCEFORID = new HashMap<Byte, PageKind>();
        INSTANCEFORCLASS = new HashMap<Class<? extends Page>, PageKind>();
        for (PageKind page : PageKind.values()) {
            INSTANCEFORID.put(page.id, page);
            INSTANCEFORCLASS.put(page.clazz, page);
        }
    }
}

