/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.page;

import io.sirix.access.DatabaseType;
import io.sirix.access.ResourceConfiguration;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.index.IndexType;
import io.sirix.node.SirixDeweyID;
import io.sirix.page.IndirectPage;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PageReference;
import io.sirix.page.SerializationType;
import io.sirix.page.delegates.BitmapReferencesPage;
import io.sirix.page.delegates.FullReferencesPage;
import io.sirix.page.delegates.ReferencesPage4;
import io.sirix.page.interfaces.Page;
import io.sirix.settings.Fixed;
import net.openhft.chronicle.bytes.BytesIn;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PageUtils {
    private PageUtils() {
        throw new AssertionError((Object)"May never be instantiated!");
    }

    public static Page setReference(Page pageDelegate, int offset, PageReference pageReference) {
        boolean hasToGrow = pageDelegate.setOrCreateReference(offset, pageReference);
        if (hasToGrow) {
            if (pageDelegate instanceof ReferencesPage4) {
                pageDelegate = new BitmapReferencesPage(1024, (ReferencesPage4)pageDelegate);
            } else {
                assert (pageDelegate instanceof BitmapReferencesPage);
                pageDelegate = new FullReferencesPage((BitmapReferencesPage)pageDelegate);
            }
            pageDelegate.setOrCreateReference(offset, pageReference);
        }
        return pageDelegate;
    }

    public static Page createDelegate(BytesIn<?> in, SerializationType type) {
        byte kind = in.readByte();
        return switch (kind) {
            case 0 -> new ReferencesPage4(in, type);
            case 1 -> new BitmapReferencesPage(1024, in, type);
            case 2 -> new FullReferencesPage(in, type);
            default -> throw new IllegalStateException();
        };
    }

    public static void createTree(DatabaseType databaseType, @NonNull PageReference reference, IndexType indexType, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        IndirectPage page = new IndirectPage();
        log.put(reference, PageContainer.getInstance(page, page));
        reference = page.getOrCreateReference(0);
        KeyValueLeafPage recordPage = new KeyValueLeafPage(Fixed.ROOT_PAGE_KEY.getStandardProperty(), indexType, pageReadTrx);
        ResourceConfiguration resourceConfiguration = pageReadTrx.getResourceSession().getResourceConfig();
        SirixDeweyID id = resourceConfiguration.areDeweyIDsStored ? SirixDeweyID.newRootID() : null;
        recordPage.setRecord(databaseType.getDocumentNode(id));
        log.put(reference, PageContainer.getInstance(recordPage, recordPage));
    }
}

